% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/episode_of_care.R
\name{episode_of_care}
\alias{episode_of_care}
\title{Identify Episodes of Care}
\usage{
episode_of_care(
  dad_df,
  nacrs_df,
  patient_id_col,
  dad_visit_date_col,
  dad_exit_date_col,
  nacrs_visit_date_col,
  nacrs_exit_date_col
)
}
\arguments{
\item{dad_df}{DataFrame containing DAD data.}

\item{nacrs_df}{DataFrame containing NACRS data.}

\item{patient_id_col}{String representing the column name for patient ID.}

\item{dad_visit_date_col}{String representing the column name for visit date in DAD data.}

\item{dad_exit_date_col}{String representing the column name for exit date in DAD data.}

\item{nacrs_visit_date_col}{String representing the column name for visit date in NACRS data.}

\item{nacrs_exit_date_col}{String representing the column name for exit date in NACRS data.}
}
\value{
A DataFrame with episodes of care identified and a unique record ID for each row.
}
\description{
This function identifies episodes of care for patients based on their visit and discharge dates
from two different data sources (DAD and NACRS).
}
\examples{
# Sample DAD data
dad_df <- data.frame(
  patient_id = c("A001", "A001", "A002", "A002", "A003"),
  admit_dt = c("01Dec2023:10:00:00", "03Jan2024:12:00:00",
  "05Jan2024:09:00:00", "07Jan2024:14:00:00", "12Jan2024:12:00:00"),
  discharge_dt = c("02Dec2023:10:00:00", "04Jan2024:10:00:00",
  "06Jan2024:10:00:00", "08Jan2024:10:00:00", "15Jan2024:08:00:00")
)

# Sample NACRS data
nacrs_df <- data.frame(
  patient_id = c("A001", "A002", "A003", "A003", "A004"),
  visit_dt = c("03Jan2024:09:00:00", "07Feb2024:15:00:00",
  "10Jan2024:09:00:00", "11Jan2024:10:00:00", "12Jan2024:11:00:00"),
  disp_dt = c("03Jan2024:11:00:00", "07Feb2024:17:00:00",
  "10Jan2024:10:00:00", "12Jan2024:12:00:00", "13Jan2024:13:00:00")
)

episode_of_care(dad_df, nacrs_df, "patient_id", "admit_dt", "discharge_dt", "visit_dt", "disp_dt")

}
