% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic.R
\name{ic-single-use}
\alias{ic-single-use}
\alias{with_ic_enable}
\alias{with_ic_disable}
\title{Temporarily enable or disable \code{ic()}}
\usage{
with_ic_enable(expr)

with_ic_disable(expr)
}
\arguments{
\item{expr}{An expression containing the \code{ic()} function.}
}
\value{
Returns the result of evaluating the expression.
}
\description{
These functions let you evaluate an expression with either \code{ic()} enabled or disabled without
affecting if \code{ic()} is enabled globally.
}
\section{Functions}{
\itemize{
\item \code{with_ic_enable()}: evaluates the expression with \code{ic()} enabled.

\item \code{with_ic_disable()}: evaluates the expression with \code{ic()} disabled.

}}
\examples{
ic_enable()

fun <- function(x) {
  ic(x * 100)
}

fun(2)

with_ic_disable(fun(2))

fun(4)

ic_disable()

fun(1)

with_ic_enable(fun(1))
}
