% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uploadStock.R
\name{uploadStock}
\alias{uploadStock}
\title{Upload New or Updated Fish Stock Assessment Results}
\usage{
uploadStock(file, upload = FALSE, verbose = FALSE)
}
\arguments{
\item{file}{the xml file to check and upload}

\item{upload}{should the file be uploaded to the database? Default is FALSE.}

\item{verbose}{if TRUE more verbose messages are reported}
}
\value{
The database key of the new / updated stock, or 0 if there was an error.
}
\description{
Get summary results of historical stock size, recruitment, and fishing
pressure.
}
\examples{
\dontrun{
info <-
stockInfo(
  StockCode = "whb-comb",
  AssessmentYear = 1996,
  ContactPerson = "its_me@somewhere.gov",
  StockCategory = 3,
  Purpose = "InitAdvice",
  ModelType = "A",
  ModelName = "XSA"
)
fishdata <- stockFishdata(1950:1996)
# simulate some landings for something a bit intesting
set.seed(1232)
fishdata$Landings <- 10^6 * exp(cumsum(cumsum(rnorm(nrow(fishdata), 0, 0.1))))

# You should write out to an xml file and then upload that file
tempfile <- tempfile(fileext = ".xml")
writeSAGxml(info, fishdata, file = tempfile)

# you can check the file is formatted correctly
uploadStock(tempfile, upload = FALSE)

# and if all checks pass, the file can be uploaded
uploadStock(tempfile, upload = TRUE)
}


}
\seealso{
\code{\link{stockInfo}} creates a list of stock information.

\code{\link{stockFishdata}} creates a data.frame of fish stock summary data.
}
\author{
Colin Millar.
}
