% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iclogcondist_simulation.R
\name{current_status_X}
\alias{current_status_X}
\title{Construct Case I Interval Censoring Data (Current Status Data)}
\usage{
current_status_X(event_times, survey_times)
}
\arguments{
\item{event_times}{A numeric vector of event times for each individual.}

\item{survey_times}{A numeric vector of censoring (survey) times for each individual.}
}
\value{
A matrix with two columns, where each row represents an individual's interval-censored data.
        The first column is the left endpoint, and the second column is the right endpoint.
        If the event time is before the survey time, the interval is \code{(0, survey_time]}.
        If the event time is after the survey time, the interval is \code{(survey_time, Inf)}.
}
\description{
This function constructs case I interval-censored data (current status data)
using the provided event times and censoring (survey) times.
Each individual's event time is either left-censored or right-censored at their survey time,
depending on whether the event has occurred by the survey time.
}
