% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_poisson.R
\name{EM_poisson}
\alias{EM_poisson}
\title{Helper function for npmsm()}
\usage{
EM_poisson(
  gd,
  tmat,
  tmat2,
  inits,
  beta_params,
  support_manual,
  exact,
  maxit,
  tol,
  conv_crit,
  manual,
  verbose,
  newmet,
  include_inf,
  checkMLE,
  checkMLE_tol,
  prob_tol,
  remove_bins,
  init_int = init_int,
  ...
)
}
\arguments{
\item{gd}{A \code{data.frame} with the following named columns
\describe{
  \item{\code{id}:}{Subject idenitifier;}
  \item{\code{state}:}{State at which the subject is observed at \code{time};}
  \item{\code{time}:}{Time at which the subject is observed;}
} The true transition time between states is then interval censored between the times.}

\item{tmat}{A transition matrix as created by \code{transMat}}

\item{inits}{Which distribution should be used to generate the initial estimates 
of the intensities in the EM algorithm. One of c("equalprob", "unif", "beta"), 
with "equalprob" assigning 1/K to each intensity, with K the number of distinct 
observation times (\code{length(unique(gd[, "time"]))}). For "unif", each 
intensity is sampled from the Unif[0,1] 
distribution and for "beta" each intensity is sampled from the Beta(a, b) distribution. 
If "beta" is chosen, the argument \code{beta_params} must be specified as a 
vector of length 2 containing the parameters of the beta distribution.
Default = "equalprob".}

\item{beta_params}{A vector of length 2 specifying the beta distribution parameters 
for initial distribution generation. First entry will be used as \code{shape1}
and second entry as \code{shape2}. See \code{help(rbeta)}. Only used if \code{inits = "beta"}.}

\item{support_manual}{Used for specifying a manual support region for the transitions.
A list of length the number of transitions in \code{tmat}, 
each list element containing a data frame with 2 named columns L and R indicating the 
left and right values of the support intervals. When specified, all intensities 
outside of these intervals will be set to zero for the corresponding transitions.
Intensities set to zero cannot be changed by the EM algorithm. Will use inits = "equalprob".}

\item{exact}{Numeric vector indicating to which states transitions are observed at exact times.
Must coincide with the column number in \code{tmat}.}

\item{maxit}{Maximum number of iterations.}

\item{tol}{Tolerance of the procedure.}

\item{conv_crit}{Convergence criterion. Stops procedure when the difference 
in the chosen quantity between two consecutive iterations is smaller 
than the tolerance level \code{tol}. One of the following:
\describe{
\item{"haz"}{Stop when change in maximum estimated intensities (hazards) \code{ < tol}.}
\item{"prob"}{Stop when change in estimated probabilities \code{ < tol}.}
\item{"lik"}{Stop when change in observed-data likelihood \code{ < tol}.}
} Default is "haz". The options "haz" and "lik" can be compared across different
\code{method}s, but "prob" is dependent on the chosen \code{method}. Most 
conservative (requiring most iterations) is "prob", followed by "haz" and finally "lik".}

\item{manual}{Manually specify starting transition intensities?}

\item{verbose}{Should iteration messages be printed? Default is FALSE}

\item{newmet}{Should contributions after last observation time also be used 
in the likelihood? Default is FALSE.}

\item{include_inf}{Should an additional bin from the largest observed time to 
infinity be included in the algorithm? Default is FALSE.}

\item{checkMLE}{Should a check be performed whether the estimate has converged 
towards a true Maximum Likelihood Estimate? Default is TRUE.}

\item{checkMLE_tol}{Tolerance for checking whether the estimate has converged to MLE.
Whenever an estimated transition intensity is smaller than the tolerance, it is assumed 
to be zero.}

\item{prob_tol}{If an estimated probability is smaller than \code{prob_tol}, 
it will be set to zero during estimation. Default value is \code{tol/10}.}

\item{remove_bins}{Should a bin be removed during the algorithm if all
estimated intensities are zero for a single bin? Can improve 
computation speed for large data sets. Note that zero means the estimated intensities 
are smaller than \code{prob_tol}. Default is FALSE.}

\item{init_int}{A vector of length 2, with the first entry indicating what 
percentage of mass should be distributed over (second entry) what percentage 
of all first bins. Default is c(0, 0), in which case the argument is ignored.
This argument has no practical uses and only exists for demonstration purposes 
in the related article.}

\item{...}{Not used yet.}
}
\description{
For a general Markov chain multi-state model with interval censored 
transitions calculate the NPMLE using an EM algorithm with Poisson latent variable approach
}
\references{
Y. Gu, D. Zeng, G. Heiss, and D. Y. Lin, 
Maximum likelihood estimation for semiparametric regression models with 
interval-censored multistate data, Biometrika, Nov. 2023, \doi{10.1093/biomet/asad073}
}
\keyword{internal}
