% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbase.R
\name{bbase_D}
\alias{bbase_D}
\title{Compute a B-spline basis}
\usage{
bbase_D(x, xl = min(x), xr = max(x), nseg = 10, bdeg = 3)
}
\arguments{
\item{x}{The vector of values for which the basis is to be evaluated}

\item{xl}{The left boundary of the domain}

\item{xr}{The right boundary of the domain}

\item{nseg}{The number of inter-knot segments on the domain}

\item{bdeg}{The degree of the B-splines (2 means quadratic, 3 means cubic, and so on)}
}
\value{
A matrix containing the basis
}
\description{
Copied from icpack/bases.R, modified diff() function for speed.
}
\examples{
x = runif(100)
B = bbase_D(x, 0, 1, 20, 3)
}
\keyword{internal}
