% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_icfit.R
\name{predict.icfit}
\alias{predict.icfit}
\title{Predict method for an object of class `icfit`}
\usage{
\method{predict}{icfit}(object, newdata, nstep = 500, alpha = 0.05, ...)
}
\arguments{
\item{object}{The object of class 'icfit' for which a prediction is to be made}

\item{newdata}{A data frame containing covariate information for a new subject}

\item{nstep}{Number of time steps used for calculating cumulative hazards (default is 500)}

\item{alpha}{The alpha level for the (1-alpha)*100 percent confidence interval}

\item{...}{Any other arguments}
}
\value{
An object of class `predict.icfit`, which is a data frame with time points and hazard,
cumulative hazard and survival at those time points, along with standard errors
and pointwise lower and upper confidence bounds, or a list of such data frames
for each subject represented in `newdata`
}
\description{
Predict method for an object of class `icfit`
}
\examples{
\donttest{
icf <- icfit(Surv(left, right, type='interval2') ~ period + gender + age, data=drugusers)
pred_icf <- predict(icf)
head(pred_icf)
ndata <- drugusers[1:4, ]
pred_nd_icf <- predict(icf, newdata=ndata)
lapply(pred_nd_icf, head)
}

}
