\name{ieTest-package}
\alias{ieTest_package}
\docType{package}
\title{
  Indirect Effects Testing methods in Mediation Analysis
}
\description{
  A package to provide a multitude of methods used in testing if the indirect effect from linear regression mediation analysis is equal to 0. Includes established methods such as the Sobel test, joint-significanct test (maxP), and test based off the distribution of the product or normal random variables. A modification of the Sobel test by Aroian is also provided. Additionally, this packed addes more powerful tests based on intersection-union theory. These tests are the S-test, the modified S-test, and the ascending squares test. These new methods are uniformly more powerful than maxP, which is more powerful than Sobel and less anti-conservative than the product of normal random variables.
}
\details{
  Functions should be used to test a hypothesis that the indirect effect is equal to zero. Alternate hypothesis values for individual effects can be specified. Functions are provided for one and two mediator scenarios.

  Test methods for one mediator and two ordered (sequential) mediators are provided for all above mentioned methods except the S-test. The S-test has logically falacies defined in (cited paper), and thus extensions to two mediators have not been conducted. In unordered (simultaneous) mediator scenarios, two mediation affects (one through each mediator) can be determined. Single mediator approaches should be used in these circumstances. For the methods defined by Sobel and Aroian, an overall test for a mediation affect exists using a sumation.

  Single mediator function names are in the format of "test_one". For ordered/sequential approaches, functions are named "test_two_seq". The two unordered approaches are called by "sobelTest_two_sim" and "aroian_two_sim".
}
\author{
John Kidd

Maintainer: John Kidd <jkidd@uvu.edu>
}
\references{
Kidd, J., Howard, A.G., Highland, H.M. et al. \emph{Hypothesis tests of indirect effects for multiple mediators}. Stat Methods Appl, 2025.  

Kidd, J., Lin, DY. \emph{Improving the Power to Detect Indirect Effects in Mediation Analysis}. Stat Biosci, 2025.
}
