#include <RcppDist.h>
#include <RcppArmadillo.h>
#include "ieTest.h"
using namespace Rcpp;

// Function not needed by R

// Function takes the estimates, variances, and covariances
// If used for gamma and psi, includes value for G if
// Also includes degrees of freedom

// Function returns the cumulative probability to be used in the 
// ps and asq-tests. 

// If there is no second term, returns the cumulative distribution
// directly from a t-distribution
// Otherwise 

double tU(double V1, double V1_VAR, int V1_DF,
             double V2 = 0, double V2_VAR = 0,
             int V2mult = 1, 
             double V1_V2_cov = 0, 
             double V1_0 = 0, double V2_0 = 0, double mcRep = 1e5){
  
  // If no second effect: 
  if((V2 == 0) & (V2_VAR == 0)){
    double t = (V1 - V1_0) / std::sqrt(V1_VAR);
    return R::pt(t, V1_DF, 1, 0 );
  }else{
    double foundVal = V1+(V2*V2mult);
    arma::mat combSig = arma::zeros(2, 2);
    combSig(0, 0) = V1_VAR;
    combSig(1, 0) = V1_V2_cov ;
    combSig(0, 1) = V1_V2_cov ;
    combSig(1, 1) = V2_VAR;
    
    // arma::mat corrMat = arma::ones(2, 2);
    // corrMat(0, 1) = V1_V2_cov / (std::sqrt(V1_VAR * V2_VAR));
    // corrMat(1, 0) = corrMat(0, 1);
    
    arma::vec newMu = arma::zeros(2);
    newMu(0) = V1_0;
    newMu(1) = V2_0;
    
    //arma::mat genT = rmvt(mcRep, newMu, corrMat, V1_DF);
    arma::mat genT = rmvt(mcRep, newMu, combSig, V1_DF);

    // Rcout << "Given Covariance\n";
    // Rcout << combSig << "\n";
    // Rcout << "Generated covariance\n";
    // Rcout << cov(genT) << "\n";
    
    arma::vec genVals = genT.col(0) + genT.col(1)*V2mult;
    
    arma::uvec lessVar = arma::find(genVals <= foundVal);

    return(lessVar.n_elem*1.0 / mcRep);
  }
}
