% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igfetchr.R
\name{ig_get_markets_by_epic}
\alias{ig_get_markets_by_epic}
\title{Get market details for one or more epics}
\usage{
ig_get_markets_by_epic(
  epics,
  auth,
  detailed = TRUE,
  mock_response = NULL,
  verbose = FALSE
)
}
\arguments{
\item{epics}{Character vector. One or more market epics (e.g., "CS.D.USDCHF.MINI.IP" or c("CS.D.USDCHF.MINI.IP", "CS.D.EURUSD.MINI.IP")).}

\item{auth}{List. Authentication details from \code{\link{ig_auth}}.}

\item{detailed}{Logical. Whether to return detailed info (instrument and dealing rules) or snapshot data only. Defaults to TRUE.}

\item{mock_response}{List or data frame. Optional mock response for testing, bypassing the API call.}

\item{verbose}{Logical. Whether to print the raw API response for debugging. Defaults to FALSE.}
}
\value{
A list with market details including instrument (epic, currencies, marginDepositBands), 
dealingRules (minStepDistance, minDealSize) and snapshot data (marketStatus, bid, offer, high, low).
}
\description{
Fetches detailed market information for the specified market epic(s) from the IG API using the `/markets` endpoint (version 2).
Returns instrument details, dealing rules, and snapshot data.
}
\examples{
\dontrun{
# Authenticate with IG API
auth <- ig_auth(
  username = Sys.getenv("IG_SERVICE_USERNAME"),
  password = Sys.getenv("IG_SERVICE_PASSWORD"),
  api_key = Sys.getenv("IG_SERVICE_API_KEY"),
  acc_type = Sys.getenv("IG_SERVICE_ACC_TYPE"),
  acc_number = Sys.getenv("IG_SERVICE_ACC_NUMBER")
)

# Example 1: Fetch details for a single epic
markets <- ig_get_markets_by_epic("CS.D.USDCHF.MINI.IP", auth)
print(markets)
# Expected output: A tibble with 1 row and 3 columns (instrument, dealingRules, snapshot)

# Example 2: Fetch details for multiple epics
markets <- ig_get_markets_by_epic(c("CS.D.USDCHF.MINI.IP", "CS.D.EURUSD.MINI.IP"), auth)
print(markets)
# Expected output: A tibble with 2 rows and 3 columns

# Example 3: Fetch snapshot data only (no instrument or dealingRules)
markets <- ig_get_markets_by_epic("CS.D.USDCHF.MINI.IP", auth, detailed = FALSE)
print(markets)
# Expected output: A tibble with 1 row and 1 column (snapshot)

# Example 4: Fetch with verbose output for debugging
markets <- ig_get_markets_by_epic("CS.D.USDCHF.MINI.IP", auth, verbose = TRUE)
print(markets)
# Expected output: Prints raw JSON response, followed by a tibble with 1 row and 3 columns

# Example 5: Use a mock response for testing
mock_response <- list(
  marketDetails = list(
    list(
      instrument = list(
        epic = "CS.D.USDCHF.MINI.IP",
        name = "USD/CHF Mini",
        currencies = list(list(code = "CHF", 
        symbol = "SF", 
        baseExchangeRate = 0.08467604, 
        isDefault = FALSE)),
        marginDepositBands = list(
          list(min = 0, max = 124, margin = 3.33, currency = "CHF"),
          list(min = 124, max = 310, margin = 3.33, currency = "CHF")
        ),
        marginFactor = 3.33,
        marginFactorUnit = "PERCENTAGE"
      ),
      dealingRules = list(
        minStepDistance = list(unit = "POINTS", value = 1.0),
        minDealSize = list(unit = "POINTS", value = 0.1)
      ),
      snapshot = list(
        marketStatus = "TRADEABLE",
        bid = 0.79715,
        offer = 0.79739,
        high = 0.79888,
        low = 0.79512,
        updateTime = "2025/09/29 18:40:51",
        binaryOdds = NA,
        decimalPlacesFactor = 5,
        scalingFactor = 10000
      )
    )
  )
)
markets <- ig_get_markets_by_epic("CS.D.USDCHF.MINI.IP", auth = NULL, mock_response = mock_response)
print(markets)
}

}
