% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{metrics_heatmap}
\alias{metrics_heatmap}
\title{Create a heatmap of metric values by subject based on hierarchical clustering order}
\usage{
metrics_heatmap(
  data = NULL,
  metrics = NULL,
  metric_cluster = 6,
  clustering_method = "complete",
  clustering_distance_metrics = "correlation",
  clustering_distance_subjects = "correlation",
  tz = ""
)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl".}

\item{metrics}{precalculated metric values, with first column corresponding to subject id. If 'NULL', the metrics are calculated from supplied 'data' using \code{\link{all_metrics}}}

\item{metric_cluster}{number of visual metric clusters, default value is 6}

\item{clustering_method}{the agglomeration method for hierarchical clustering, accepts same values as \code{\link{hclust}}, default value is 'complete'}

\item{clustering_distance_metrics}{the distance measure for metrics clustering, accepts same values as \code{\link{dist}}, default value is 'correlation' distance}

\item{clustering_distance_subjects}{the distance measure for subjects clustering, accepts same values as \code{\link{dist}}, default value is 'correlation' distance}

\item{tz}{\strong{Default: "".} A character string specifying the time zone to be used. System-specific (see \code{\link{as.POSIXct}}), but " " is the current time zone, and "GMT" is UTC (Universal Time, Coordinated). Invalid values are most commonly treated as UTC, on some platforms with a warning.}
}
\value{
A heatmap of metrics by subjects generated via \code{\link[pheatmap]{pheatmap}}
}
\description{
Create a heatmap of metric values by subject based on hierarchical clustering order
}
\examples{
# Using pre-calculated sd metrics only rather than default (all metrics)
mecs = sd_measures(example_data_5_subject)
metrics_heatmap(metrics = mecs)
}
