% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axes.R
\name{reorder_cols}
\alias{reorder_cols}
\alias{reorder_cols,IheatmapHorizontal,integer-method}
\alias{reorder_cols,IheatmapVertical,integer-method}
\title{reorder_cols}
\usage{
\S4method{reorder_cols}{IheatmapHorizontal,integer}(p, col_order, xname = current_xaxis(p))

\S4method{reorder_cols}{IheatmapVertical,integer}(p, col_order)
}
\arguments{
\item{p}{\code{\link{Iheatmap-class}} object}

\item{col_order}{integer vector}

\item{xname}{name of xaxis to reorder, only applicable if object is oriented
horizontally}
}
\value{
\code{\link{Iheatmap-class}} object, which can be printed to generate 
an interactive graphic
}
\description{
Reorder the columns of an \code{\link{Iheatmap-class}} object
}
\examples{

mat <- matrix(rnorm(20), ncol = 5, nrow = 4)  
dend <- hclust(dist(t(mat)))
hm <- iheatmap(mat) \%>\% reorder_cols(dend$order)

# Print heatmap if interactive session 
if (interactive()) hm 
}
\seealso{
\code{\link{add_row_clustering}}, \code{\link{reorder_cols}}
}
\author{
Alicia Schep
}
