% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resizeImages.R
\name{resizeImages}
\alias{resizeImages}
\title{Resize and save images}
\usage{
resizeImages(
  imageDir,
  fileNames,
  pattern,
  patternInclude = TRUE,
  type,
  dimensions,
  validRegion,
  preserveAspect = TRUE,
  filter = NULL,
  colorspace,
  binary,
  gravity = "Center",
  imageFormats = c("JPG|TIF|PNG|JPEG|TIFF"),
  outDir,
  cores = 1,
  compression = "Lossless"
)
}
\arguments{
\item{imageDir}{Character. Directory containing raw images}

\item{fileNames}{character. File names to load (they will still be filtered by \code{pattern}, if defined)}

\item{pattern}{character. Pattern to search in file names}

\item{patternInclude}{logical. Include images with pattern in file names (TRUE) or exclude (FALSE)}

\item{type}{character. "canopy" or "understory". Will set image dimensions accordingly to predefined c(256, 256) or c(160, 256), respectively (optional). Alternatively, use \code{dimensions}.}

\item{dimensions}{integer. image dimensions provides as c(width, height) in pixels. If specified, overrides \code{type}}

\item{validRegion}{character. If defined, use string as argument \code{geometry} in \code{\link[magick]{image_crop}} (output of \code{\link[magick]{geometry_area}}), which will crop all images to the same region before resizing (optional). If undefined, don't crop.}

\item{preserveAspect}{logical. If TRUE, images will be cropped to aspect ratio of output before resizing (thus preserving original aspect ratio, but losing parts of the image). If FALSE, images will be simply resized from their input size to the desired output (not preserving aspect ratio).}

\item{filter}{character. Resampling filter. Passed to argument \code{filter} in \code{\link[magick]{image_resize}}. See \code{magick::filter_types()} for available options. Default is LanczosFilter.}

\item{colorspace}{character. If defined, image will be converted to the requested colorspace. If undefined, colorspace will remain unchanged. Must be a valid argument to  \code{magick::colorspace_types()}. In practice, only "sRGB" and "Gray" will be relevant.}

\item{binary}{logical. If colorspace is "Gray", make the output binary?}

\item{gravity}{if preserveAspect = TRUE and images need to be cropped, the \code{gravity} argument to use in \code{\link[magick]{image_crop}}.}

\item{imageFormats}{character. Image file formats to read.}

\item{outDir}{character. Directory to save resized images in.}

\item{cores}{integer. Number of cores to use for parallel processing}

\item{compression}{character. Compression type to use in \code{\link[magick]{image_write}}. See \code{\link[magick]{compress_types}}. By default, "Lossless" for grayscale images, "Undefined" for color images.}
}
\value{
No R output, only resized images are saved on disk
}
\description{
Resize and save images
}
\details{
Resizing is done by \code{\link[magick]{image_resize}} and will ensure that the resized images have exactly the desired dimensions.

If \code{preserveAspect = TRUE}, input images will first be cropped to the maximum area with the aspect ratio of the desired output (1:1 (square) for \code{type = "canopy"}, 5:8 for \code{type = "understory"}), by default in the center of the input image (argument \code{gravity}). This will usually lead to the loss of parts of the image, but the remaining part of the image is not deformed compared to the original.
Alternatively, if \code{preserveAspect = FALSE}, input images will be resized to the requested dimensions without cropping (thus no loss of part of the image), but the aspect ratio changes. If aspect ratio changes too strongly it may negatively affect model performance.

Resizing is done using "!" in the geometry syntax. See \code{\link[magick]{geometry}} for details.

compression = "Lossless" is used to ensure no compression artefacts in saved images (which would for example introduce grayscale values in black/white images). If small file sizes are important, you can change it to save compressed images.
}
\examples{
# Example 1: Canopy
wd_can <- system.file("images/canopy/raw",
                      package = "imageseg")

wd_out_can <- file.path(tempdir(), "canopy", "resized")
resizeImages(imageDir = wd_can,
             type = "canopy",
             outDir = wd_out_can)

filename_resized <- list.files(wd_out_can, full.names = TRUE)

# check output
img_can <- magick::image_read(filename_resized)
img_can

# Example 2: Understory
wd_us <- system.file("images/understory/raw",
                      package = "imageseg")
wd_out_us <- file.path(tempdir(), "understory", "resized")

# note, these are png images
resizeImages(imageDir = wd_us,
             type = "understory",
             outDir = wd_out_us)

filename_resized <- list.files(wd_out_us, full.names = TRUE)

# check output
img_us <- magick::image_read(filename_resized)
img_us

}
