% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{kernel_3d}
\alias{kernel_3d}
\alias{kernels}
\alias{kernel_2d}
\alias{kernel_box}
\alias{kernel_gauss}
\alias{kernel_sphere}
\alias{kernel_file}
\title{Mathematical morphology kernels}
\usage{
kernel_3d(image)

kernel_2d(image)

kernel_box(image, width, voxels = FALSE)

kernel_gauss(image, sigma)

kernel_sphere(image, radius)

kernel_file(image, file)
}
\arguments{
\item{image}{An image object or pipeline.}

\item{width}{The width of the kernel in appropriate units. If \code{voxels}
is \code{FALSE} a value can be specified for each of the three dimensions;
otherwise only a single value should be given and the kernel will be
isotropic.}

\item{voxels}{Logical value: if \code{TRUE}, the \code{width} is given in
pixels/voxels and must be an odd integer; otherwise, the units are
millimetres and can take any value.}

\item{sigma}{Numeric value giving the standard deviation of a Gaussian
kernel, in millimetres.}

\item{radius}{Numeric value giving the radius of a sphere kernel, in
millimetres.}

\item{file}{Name of a NIfTI file containing the kernel.}
}
\value{
An updated pipeline.
}
\description{
Mathematical morphology kernels
}
