% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{threshold}
\alias{threshold}
\alias{threshold_below}
\alias{threshold_above}
\title{Image thresholding}
\usage{
threshold(
  image,
  value,
  reference = c("none", "image", "nonzero"),
  above = FALSE
)

threshold_below(image, value, reference = c("none", "image", "nonzero"))

threshold_above(image, value, reference = c("none", "image", "nonzero"))
}
\arguments{
\item{image}{An image object or pipeline.}

\item{value}{Numeric threshold value.}

\item{reference}{String indicating what the \code{value} should be
referenced against, if anything. If \code{"none"}, the default, the
\code{value} is taken literally. If \code{"image"}, it is interpreted as
a proportion of the "robust range" of the current image's intensities. If
\code{"nonzero"} it is interpreted as a proportion of the "robust range"
of the nonzero pixel intensities.}

\item{above}{Logical value: if \code{TRUE} the operation zeroes values above
the threshold; otherwise it zeroes values below it. The
\code{threshold_below} and \code{threshold_above} function variants set
argument implicitly.}
}
\value{
An updated pipeline.
}
\description{
Image thresholding
}
