% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imf_get_dataflows.R
\name{imf_get_dataflows}
\alias{imf_get_dataflows}
\title{Get dataflow definitions for aLL available IMF datasets}
\usage{
imf_get_dataflows(progress = FALSE, max_tries = 10L, cache = TRUE)
}
\arguments{
\item{progress}{Logical; whether to show progress.}

\item{max_tries}{Integer; maximum retry attempts.}

\item{cache}{Logical; whether to cache the request.}
}
\value{
tibble::tibble(
id = character(),           # e.g., "MFS_IR", "SPE", etc.
name = character(),         # English name
description = character(),  # English description
version = character(),      # e.g., "8.0.1"
structure = character(),    # DSD reference
last_updated = character() # from annotations
)
}
\description{
Retrieves and returns all available dataflow definitions from the SDMX
dataflow endpoint.
}
\examples{
\donttest{
if (curl::has_internet()) {
  imf_get_dataflows()
}
}
}
