% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_unsupervised.R
\name{impute_unsupervised}
\alias{impute_unsupervised}
\title{Unsupervised imputation}
\usage{
impute_unsupervised(
  ds,
  model_fun,
  predict_fun,
  rows_used_for_imputation = "only_complete",
  rows_order = seq_len(nrow(ds)),
  update_model = "every_iteration",
  update_ds_model = "every_iteration",
  model_arg = NULL,
  M = is.na(ds),
  ...
)
}
\arguments{
\item{ds}{The data set to be imputed. Must be a data frame with column names.}

\item{model_fun}{An unsupervised model function which take as arguments
\code{ds_used} (the data set used to build the model, specified via
\code{rows_used_for_imputation}), \code{M} and \code{i} (the index of the row currently
under imputation).}

\item{predict_fun}{A predict function which uses the via \code{model_fun}
generated model (\code{model_imp}) to predict the missing values of a row. It
should take the arguments \code{model_imp}, \code{ds_used}, \code{M} and \code{i}.}

\item{rows_used_for_imputation}{Which rows should be used to impute other
rows? Possible choices:
"only_complete", "already_imputed", "all_except_i", "all"}

\item{rows_order}{Ordering of the rows for imputation. This can be a vector
with indices or an \code{order_option} from \code{\link[=order_rows]{order_rows()}}.}

\item{update_model}{How often should the model for imputation be updated?
Possible choices are: "everytime" (after every imputed value) and
"every_iteration" (only one model is created and used for all missing
values).}

\item{update_ds_model}{How often should the data set for the inner model be
updated? Possible choices are: "everytime" (after every imputed value),
and "every_iteration".}

\item{model_arg}{Further arguments for \code{model_fun}. This can be a list, if
it is more than one argument.}

\item{M}{Missing data indicator matrix}

\item{...}{Further arguments given to \code{predict_fun}.}
}
\value{
The imputed data set.
}
\description{
Impute a data set with an unsupervised inner method. This function is one
main function which can be used inside of \code{\link[=impute_iterative]{impute_iterative()}}. If you need
pre-imputation or iterations, directly use \code{\link[=impute_iterative]{impute_iterative()}}.
}
\details{
This function imputes the rows of the data set \code{ds} row by
row. The imputation order of the rows can be specified by \code{rows_order}.
Furthermore, \code{rows_used_for_imputation} controls which rows are used for
the imputation. If \code{ds} is pre-imputed, the missing data indicator matrix
can be supplied via \code{M}.

The inner method used to impute the data set can be defined with \code{model_fun}.
This \code{model_fun} must take a data set, the missing data indicator matrix \code{M},
the index \code{i} of the row which should be imputed right now (which is \code{NULL},
if the model is updated only once per iteration or only uses complete rows)
and \code{model_arg} in this order. It must return a model \code{model_imp} which is
given to \code{predict_fun} to generate imputation values for the missing values
in a row \code{i}. The \code{model_fun} and \code{predict_fun} can be self-written or a
predefined one (see below) can be used.

If \code{update_model = "every_iteration"} only one model is fitted and the
argument \code{update_ds_model} is ignored. This option can be considerably
faster than \code{update_model = "everytime"}, especially, for data sets with
many rows with missing values. However, some methods (like nearest
neighbors) need \code{update_model = "everytime"}.
}
\examples{
ds_mis <- missMethods::delete_MCAR(
  data.frame(X = rnorm(20), Y = rnorm(20)), 0.2, 1
)
impute_unsupervised(ds_mis, model_donor, predict_donor)
# knn imputation with k = 2
impute_unsupervised(ds_mis, model_donor, predict_donor,
  update_model = "everytime", model_arg = list(k = 2)
)
}
\seealso{
\code{\link[=model_donor]{model_donor()}} and \code{\link[=predict_donor]{predict_donor()}} for a pair of predefined
functions for \code{model_fun} and \code{predict_fun}.
}
