% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logit.R
\docType{class}
\name{logit}
\alias{logit}
\title{Bayesian Logit Model Factory}
\description{
A class for creating and managing Bayesian Logit Models
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{version}}{im package version used to fit model}

\item{\code{tau_draws}}{Posterior draws for the treatment effect}

\item{\code{mcmChecks}}{MCMC diagnostics}

\item{\code{credible_interval}}{Credible interval for the treatment effect}

\item{\code{prior_eta}}{Prior distribution for eta}

\item{\code{prior_tau}}{Prior distribution for tau}

\item{\code{prior_mean_y}}{Prior distribution for mean y}

\item{\code{eta_draws}}{Posterior draws for eta}

\item{\code{predict_list}}{List of predictions}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-logit-new}{\code{logit$new()}}
\item \href{#method-logit-tracePlot}{\code{logit$tracePlot()}}
\item \href{#method-logit-calcProb}{\code{logit$calcProb()}}
\item \href{#method-logit-pointEstimate}{\code{logit$pointEstimate()}}
\item \href{#method-logit-credibleInterval}{\code{logit$credibleInterval()}}
\item \href{#method-logit-vizdraws}{\code{logit$vizdraws()}}
\item \href{#method-logit-lollipop}{\code{logit$lollipop()}}
\item \href{#method-logit-plotPrior}{\code{logit$plotPrior()}}
\item \href{#method-logit-predict}{\code{logit$predict()}}
\item \href{#method-logit-getPred}{\code{logit$getPred()}}
\item \href{#method-logit-predSummary}{\code{logit$predSummary()}}
\item \href{#method-logit-predCompare}{\code{logit$predCompare()}}
\item \href{#method-logit-clone}{\code{logit$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logit-new"></a>}}
\if{latex}{\out{\hypertarget{method-logit-new}{}}}
\subsection{Method \code{new()}}{
Get the package version


Get the posterior draws for tau


Get the MCMC diagnostics


Get the credible interval


Get the prior for eta


Get the prior for tau


Get the prior for mean y


Get the posterior draws for eta


Get the list of predictions


Create a new Bayesian Logit Model object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{logit$new(
  data,
  y,
  x,
  treatment,
  mean_alpha,
  sd_alpha,
  mean_beta,
  sd_beta,
  tau_mean,
  tau_sd,
  seed = 1982,
  fit = TRUE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{Data frame to be used}

\item{\code{y}}{Name of the outcome variable in the data frame}

\item{\code{x}}{Vector of names of all covariates in the data frame}

\item{\code{treatment}}{Name of the treatment indicator variable in the data frame}

\item{\code{mean_alpha}}{Prior mean for alpha}

\item{\code{sd_alpha}}{Prior standard deviation for alpha}

\item{\code{mean_beta}}{Prior mean for beta}

\item{\code{sd_beta}}{Prior standard deviation for beta}

\item{\code{tau_mean}}{Prior mean for the treatment effect estimation}

\item{\code{tau_sd}}{Prior standard deviation for the treatment effect estimation}

\item{\code{seed}}{Seed for Stan fitting}

\item{\code{fit}}{Flag for fitting the data to the model or not}

\item{\code{...}}{Additional arguments for Stan}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisible
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logit-tracePlot"></a>}}
\if{latex}{\out{\hypertarget{method-logit-tracePlot}{}}}
\subsection{Method \code{tracePlot()}}{
Plot MCMC trace for the eta and sigma parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{logit$tracePlot(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional arguments for Stan}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logit-calcProb"></a>}}
\if{latex}{\out{\hypertarget{method-logit-calcProb}{}}}
\subsection{Method \code{calcProb()}}{
Calculates the posterior of an effect being greater than, less than,
or within a range defined by thresholds.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{logit$calcProb(a = 0, b = NULL, prior = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{a}}{Optional. Lower bound for the threshold.}

\item{\code{b}}{Optional. Upper bound for the threshold.}

\item{\code{prior}}{Logical. If TRUE, calculates probabilities based on
the prior distribution.
If FALSE (default), uses the posterior distribution.}

\item{\code{x}}{A numeric vector containing draws from the posterior}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character string summarizing the estimated probability

Calculate point estimate of the effect

This R6 method calculates the point estimate of the effect size
based on the posterior draws of the eta parameter.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logit-pointEstimate"></a>}}
\if{latex}{\out{\hypertarget{method-logit-pointEstimate}{}}}
\subsection{Method \code{pointEstimate()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{logit$pointEstimate(median = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{median}}{Logical value. If TRUE (default), the median of
the eta draws is returned. If FALSE, the mean is returned.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method uses the private$..eta_draws internal variable
which contains MCMC draws of the eta parameter representing the
effect size. Based on the specified median argument, the method
calculates and returns either the median or the mean of the draws.
Calculates credible interval for the effect of the intervention

This R6 method calculates and returns a formatted statement summarizing
the credible interval of a specified width for the effect of the intervention.
}

\subsection{Returns}{
A numeric value representing the point estimate.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logit-credibleInterval"></a>}}
\if{latex}{\out{\hypertarget{method-logit-credibleInterval}{}}}
\subsection{Method \code{credibleInterval()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{logit$credibleInterval(width = 0.75, round = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{width}}{Numeric value between 0 and 1 representing the desired
width of the credible interval (e.g., 0.95 for a 95\% credible interval).}

\item{\code{round}}{Integer value indicating the number of decimal places to round
the lower and upper bounds of the credible interval.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method uses the private$..eta_draws internal variable
containing MCMC draws of the eta parameter representing the effect
size. It calculates the credible interval, stores it internally, and
returns a formatted statement summarizing the findings.
}

\subsection{Returns}{
A character string with the following information:
\itemize{
\item The probability associated with the specified width
\item The lower and upper bounds of the credible interval, rounded to the
specified number of decimal places
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logit-vizdraws"></a>}}
\if{latex}{\out{\hypertarget{method-logit-vizdraws}{}}}
\subsection{Method \code{vizdraws()}}{
Plots impact's prior and posterior distributions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{logit$vizdraws(tau = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tau}}{Logical. If TRUE, plot tau instead of eta}

\item{\code{...}}{other arguments passed to vizdraws.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An interactive plot of the prior and posterior distributions.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logit-lollipop"></a>}}
\if{latex}{\out{\hypertarget{method-logit-lollipop}{}}}
\subsection{Method \code{lollipop()}}{
Plots lollipop chart for the prior and posterior of the impact being
greater or less than a threshold.

For more details see \code{\link[vizdraws:lollipops]{vizdraws::lollipops()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{logit$lollipop(threshold = 0, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{threshold}}{cutoff used to calculate the probability. Defaults to
zero percent points}

\item{\code{...}}{other arguments passed to vizdraws.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A lollipop chart with the prior and posterior probability of
the impact being above or below a threshold.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logit-plotPrior"></a>}}
\if{latex}{\out{\hypertarget{method-logit-plotPrior}{}}}
\subsection{Method \code{plotPrior()}}{
Plots draws from the prior distribution of the outcome, tau, and impact
in percentage points.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{logit$plotPrior()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logit-predict"></a>}}
\if{latex}{\out{\hypertarget{method-logit-predict}{}}}
\subsection{Method \code{predict()}}{
Predict new data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{logit$predict(new_data, name = NULL, M = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_data}}{Data frame to be predicted}

\item{\code{name}}{Group name of the prediction}

\item{\code{M}}{Number of posterior draws to sample from}

\item{\code{...}}{Additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisible(self)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logit-getPred"></a>}}
\if{latex}{\out{\hypertarget{method-logit-getPred}{}}}
\subsection{Method \code{getPred()}}{
Get posterior predictive draws
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{logit$getPred(name = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Group name of the prediction}

\item{\code{...}}{Additional arguments (not used)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Matrix of posterior predictive draws
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logit-predSummary"></a>}}
\if{latex}{\out{\hypertarget{method-logit-predSummary}{}}}
\subsection{Method \code{predSummary()}}{
Get point estimate, credible interval and prob summary of predictive draws
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{logit$predSummary(
  name = NULL,
  subgroup = NULL,
  median = TRUE,
  width = 0.75,
  round = 0,
  a = NULL,
  b = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Optional. Group name of the prediction}

\item{\code{subgroup}}{Optional. A boolean vector to get summary on the conditional group average}

\item{\code{median}}{Optional. Logical value for using median or mean}

\item{\code{width}}{Optional. Numeric value for credible interval width}

\item{\code{round}}{Optional. Integer value for rounding}

\item{\code{a}}{Optional. Lower bound threshold}

\item{\code{b}}{Optional. Upper bound threshold}

\item{\code{...}}{Additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character string with summary information
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logit-predCompare"></a>}}
\if{latex}{\out{\hypertarget{method-logit-predCompare}{}}}
\subsection{Method \code{predCompare()}}{
Compare the average of the posterior draws of two groups
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{logit$predCompare(
  name1,
  name2,
  subgroup1 = NULL,
  subgroup2 = NULL,
  median = TRUE,
  width = 0.75,
  round = 0,
  a = NULL,
  b = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name1}}{Group name of the first prediction to be compared}

\item{\code{name2}}{Group name of the second prediction to be compared}

\item{\code{subgroup1}}{Optional. A boolean vector for the first group}

\item{\code{subgroup2}}{Optional. A boolean vector for the second group}

\item{\code{median}}{Optional. Logical value for using median or mean}

\item{\code{width}}{Optional. Numeric value for credible interval width}

\item{\code{round}}{Optional. Integer value for rounding}

\item{\code{a}}{Optional. Lower bound threshold}

\item{\code{b}}{Optional. Upper bound threshold}

\item{\code{...}}{Additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character string with comparison summary
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logit-clone"></a>}}
\if{latex}{\out{\hypertarget{method-logit-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{logit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
