% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{logitRng}
\alias{logitRng}
\title{Calculate logit link and sample from binomial distribution}
\usage{
logitRng(alpha, tau, beta, treat, X, N)
}
\arguments{
\item{alpha}{Numeric. A draw of alpha param from the logit model}

\item{tau}{Numeric. A draw of tau param from the logit model}

\item{beta}{Vector. A draw of beta params from the logit model}

\item{treat}{A 0 / 1 vector of treatment indicator}

\item{X}{Data to be predicted}

\item{N}{Numeric. Size of the sample, should depend on size of the data.}
}
\value{
A vector of N samples of preditive draws
}
\description{
This function takes prior / posterior draws of the Bayesian logit model,
applies theinverse logit (logistic) transformation to obtain probabilities,
and then generates random samples from binomial distributions.
}
