% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{fit_incidence}
\alias{fit_incidence}
\title{Fit incidence curve to reported data}
\usage{
fit_incidence(
  reported,
  delay_dist,
  dof_grid = seq(6, 20, 2),
  dof_method = "aic",
  lam_grid = 10^(seq(-1, -8, length.out = 20)),
  lam_method = "val",
  percent_thresh = 2,
  regularization_order = 2,
  num_ar_steps = 10,
  num_ar_samps = 100,
  linear_tail = 14,
  front_pad_size = 10,
  extrapolation_prior_precision = 10,
  frac_train = 0.75,
  fisher_approx_cov = TRUE,
  end_pad_size = 50,
  num_samps_per_ar = 10,
  val_restarts = 2,
  seed = 1
)
}
\arguments{
\item{reported}{An integer vector of reported cases.}

\item{delay_dist}{A positive vector that sums to one, which describes the delay distribution.}

\item{dof_grid}{An integer vector of degrees of freedom for the spline basis.}

\item{dof_method}{Metric to choose "best" spline degrees of freedom: 'aic': Akaike information 
criterion, 'bic': Bayesian information criterion, 'val': validation likelihood.}

\item{lam_grid}{A vector of regularization strengths to scan.}

\item{lam_method}{metric to choose "best" regularization strength lambda: 'aic': Akaike information 
criterion, 'bic': Bayesian information criterion, 'val': validation likelihood.}

\item{percent_thresh}{If using validation likelihood to select best,
the largest (strongest) lambda that is within `percent_thresh` of
the highest validation lambda will be selected. Default is 2. Must be greater than 0.}

\item{regularization_order}{An integer (typically 0, 1, 2), indicating differencing order for L2 
regularization of spline parameters. Default is 2 for second derivative penalty.}

\item{num_ar_steps}{An integer number of AR steps after last observation.}

\item{num_ar_samps}{An integer number of AR samples.}

\item{linear_tail}{An integer number of days used to fit linear model on tail to be used as a mean
for AR extrapolation.}

\item{front_pad_size}{An integer for initial number of 0's before first observation.}

\item{extrapolation_prior_precision}{A positive scalar for extrapolation slope shrinkage prior precision.}

\item{frac_train}{A numeric between 0 and 1 for fraction of data used to train lambda validation.}

\item{fisher_approx_cov}{A flag to use either the Fisher Information (TRUE) or the Hessian (FALSE) to approx posterior covariance over parameters.}

\item{end_pad_size}{And integer number of steps the spline is defined beyond the final 
observation.}

\item{num_samps_per_ar}{An integer for the number of Laplace samples per AR fit.}

\item{val_restarts}{An integer for the number of times to refit hyperparameters if 'val' is used for 
either. Set to 1 for faster but more unstable fits.}

\item{seed}{Seed for RNG.}
}
\value{
A list with the following entries: \itemize{
        \item Isamps -- sample of the incidence curve from a Laplace approximation per AR sample;
        \item Ihat -- MAP incidence curve estimate;
        \item Chat -- expected cases given MAP incidence curve estimate;
        \item beta_hats -- matrix of beta's per AR sample;
        \item best_dof -- best degrees of freedom from tuning;
        \item best_lambda -- best regularization parameter from tuning; and
        \item reported -- a copy of reported values used for fitting.}
}
\description{
This is a function that fits an incidence curve to a set of reported cases and delay distribution
using an empirical Bayes estimation method, which fits parameters for a spline basis. All hyper 
parameter tuning and data processing are done within this function.
}
\examples{
\donttest{
indiana_model <- fit_incidence(
                  reported = spanish_flu$Indiana, 
                  delay_dist = spanish_flu_delay_dist$proportion) }
}
