#' Create IMR chart for statistical process control
#' 
#' @description
#' Generate a single point time series chart from a set of consecutive measurements.
#' 
#' @details
#' This type of chart is typically applied in product manufacturing to monitor
#' deviations from the target value over time. It is usually accompanied by 
#' the \code{\link{chart_IMR}}
#' 
#' @references 
#' For a complete case study application refer to \url{https://j-ramalho.github.io/industRial/}
#'
#' @param data
#' A dataset generated by the function \code{\link{process_stats}}
#'
#' @return
#' This function returns an object of class ggplot
#' @export
#' @importFrom magrittr %>%
chart_I <- function(data) {
  data %>%
    ggplot2::ggplot(ggplot2::aes(x = data$part_id, y = data$weight_value)) +
    ggplot2::geom_line() +
    ggplot2::geom_point() +
    ggplot2::geom_hline(ggplot2::aes(yintercept = data$spec_min), color = "red", linetype = 3) +
    ggplot2::geom_hline(ggplot2::aes(yintercept = data$spec_max), color = "red", linetype = 3) +
    ggplot2::geom_hline(ggplot2::aes(yintercept = data$weight_target_value), color = "red", linetype = 2) +
    ggplot2::geom_hline(ggplot2::aes(yintercept = data$I_UCL), color = "deepskyblue4", linetype = 3) +
    ggplot2::geom_hline(ggplot2::aes(yintercept = data$I_LCL), color = "deepskyblue4", linetype = 3) +
    ggplot2::geom_hline(ggplot2::aes(yintercept = data$weight_mean), color = "deepskyblue4", linetype = 2) +
    ggplot2::geom_point(ggplot2::aes(x = data$part_id, y = data$weight_out_limits), color = "red") +
    ggplot2::scale_y_continuous(n.breaks = 10) +
    ggplot2::theme_light() +
    ggplot2::theme(axis.text.x = ggplot2::element_text(size = 8)) +
    ggplot2::labs(
      title = "Weight SPC",
      subtitle = "I-chart",
      x = "Part id",
      y = "Weight Mean [g]",
      caption = "data source: Line1"
    ) +
    industRial::theme_qcc()
}