% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_qcc.R
\name{theme_qcc}
\alias{theme_qcc}
\title{Custom theme "qcc" for the book industRial Data Science plots}
\usage{
theme_qcc(base_size = 12, base_family = "")
}
\arguments{
\item{base_size}{font size, defaults to 12}

\item{base_family}{font family defaults to ""}
}
\value{
This function returns an object of classes theme and gg from the ggplot2 package
}
\description{
This theme provides a similar look and feel to the package \code{\link[qcc]{qcc}}
statistical process control charts (SPC) which have themselves a resemblance with 
Minitab charts. This theme aims at providing a layout that is familiar to readers
of Minitab chart to help in reducing transition to R build reports and charts.
}
\details{
Apply this theme by adding it at the end of the code of any \code{\link[ggplot2]{ggplot}} chart.
It #' basically provides a grey background and some highlights to help reading key
process statistics such as the population mean.
}
\examples{
library(dplyr)
library(ggplot2)

pet_delivery \%>\% 
   ggplot(aes(x = A)) +
   geom_histogram(color = "grey", fill = "grey90") +
   labs(title = "PET clothing case study",
      subtitle = "Raw data plot",
      x = "Treatment",
      y = "Tensile strength [MPa]") +
      theme_qcc()
}
\references{
For a complete case study application refer to \url{https://j-ramalho.github.io/industRial/}
}
