% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.shrimp.R
\docType{data}
\name{shrimp}
\alias{shrimp}
\title{Blue and red shrimp in the Western Mediterranean Sea}
\format{
A list of objects:
\describe{
\item{\code{hauls}:}{ An \code{sf} object containing haul locations}
\item{\code{mesh}:}{ An \code{fm_mesh_2d} object containing a Delaunay triangulation
mesh (a type of discretization of continuous space) covering the haul
locations.}
\describe{
\item{\code{catch}}{Catch in Kg.}
\item{\code{landing}}{Landing in Kg.}
\item{\code{depth}}{Mean depth (in metres) of the fishery haul.}
}
}
}
\source{
Pennino, Maria Grazia. Personal communication.
}
\usage{
data(shrimp)
}
\description{
Blue and red shrimp in the Western Mediterranean Sea.
}
\examples{
\donttest{
if (require(ggplot2, quietly = TRUE)) {
  data(shrimp, package = "inlabru", envir = environment())
  ggplot() +
    geom_fm(data = shrimp$mesh) +
    gg(shrimp$hauls, aes(col = catch)) +
    coord_sf(datum = fm_crs(shrimp$hauls))
}
}
}
\references{
Pennino, M. G., Paradinas, I., Munoz, F., Illian, J.,Quilez-Lopez, A.,
Bellido, J.M., Conesa, D. Accounting for preferential sampling in species
distribution models. Ecology and Evolution, 9(1), p653-663, 2019
\doi{10.1002/ece3.4789}
}
\keyword{datasets}
