% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash.R
\name{hash}
\alias{hash}
\title{Convert sequences to MD5 hashes.}
\usage{
hash(x)
}
\arguments{
\item{x}{a sequence or list of sequences, either in character string,
character vector, or raw byte format (eg DNAbin or AAbin objects).}
}
\value{
a character vector.
}
\description{
This function converts DNA or amino acid sequences to 128-bit
   MD5 hash values for efficient duplicate identification and dereplication.
}
\details{
This function uses the \code{md5} function from the openSSL library
  (\url{https://www.openssl.org/})
  to digest sequences to 128-bit hashes.
  These can be compared using base functions such
  as \code{duplicated} and \code{unique}, for fast identification and
  management of duplicate sequences in large datasets.
}
\examples{
 data(whales)
 hashes <- hash(whales)
 sum(duplicated(hashes))
}
\references{
Ooms J (2017) openssl: toolkit for encryption, signatures and
    certificates based on OpenSSL. R package version 0.9.7.
    \url{https://CRAN.R-project.org/package=openssl}
}
\author{
Shaun Wilkinson
}
