% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLikes.R
\name{getLikes}
\alias{getLikes}
\title{Get the list of users who liked a photo.}
\usage{
getLikes(id, token, verbose = TRUE)
}
\arguments{
\item{id}{Numeric ID of photo.}

\item{token}{An OAuth token created with \code{instaOAuth}.}

\item{verbose}{If \code{TRUE} (default), outputs details about progress
of function on the console.}
}
\description{
\code{getLikes} retrieves the list of users who liked a photo.
}
\details{
IMPORTANT: After June 1st, 2016 only applications that have passed permission
review by Instagram will be allowed to access data for users other than the
authenticated user. See  \url{https://www.instagram.com/developer/review/} 
for more information.
}
\examples{
\dontrun{
## See examples for instaOAuth to know how token was created.
## Downloading list of users who liked @barackobama's most recent photo
 load("my_oauth")
 obama <- getUserMedia( username="barackobama", token=my_oauth, n=1)
 likes <- getLikes(obama$id[1], token=my_oauth)
}

}
\author{
Tiago Dantas \email{t.mendesdantas@gmail.com}
}

