% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bssmle.R
\name{bssmle}
\alias{bssmle}
\title{B-spline Sieve Maximum Likelihood Estimation}
\usage{
bssmle(formula, data, alpha, k = 1)
}
\arguments{
\item{formula}{a formula object relating survival object \code{Surv2(v, u, event)} to a set of covariates}

\item{data}{a data frame that includes the variables named in the formula argument}

\item{alpha}{\eqn{\alpha = (\alpha1, \alpha2)} contains parameters that define the link functions from class of generalized odds-rate transformation models. The components \eqn{\alpha1} and \eqn{\alpha2} should both be \eqn{\ge 0}. If \eqn{\alpha1 = 0}, the user assumes the proportional subdistribution hazards model or the Fine-Gray model for the cause of failure 1. If \eqn{\alpha2 = 1}, the user assumes the proportional odds model for the cause of failure 2.}

\item{k}{a parameter that controls the number of knots in the B-spline with \eqn{0.5 \le }\code{k}\eqn{ \le 1}}
}
\value{
The function \code{bssmle} returns a list of components:
\item{beta}{a vector of the estimated coefficients for the B-splines}
\item{varnames}{a vector containing variable names}
\item{alpha}{a vector of the link function parameters}
\item{loglikelihood}{a loglikelihood of the fitted model}
\item{convergence}{an indicator of convegence}
\item{tms}{a vector of the minimum and maximum observation times}
\item{Z}{a set of covariates}
\item{Tv}{a vector of \code{v}}
\item{Tu}{a vector of \code{u}}
\item{Bv}{a list containing the B-splines basis functions evaluated at \code{v}}
\item{Bu}{a list containing the B-splines basis functions evaluated at \code{v}}
\item{dBv}{a list containing the first derivative of the B-splines basis functions evaluated at \code{v}}
\item{dBu}{a list containing the first derivative of the B-splines basis functions evaluated at \code{u}}
\item{dmat}{a matrix of event indicator functions}
}
\description{
Routine that performs B-spline sieve maximum likelihood estimation with linear and nonlinear inequality/equality constraints
}
\details{
The function \code{bssmle} performs B-spline sieve maximum likelihood estimation.
}
\author{
Giorgos Bakoyannis, \email{gbakogia@iu.edu}

Jun Park, \email{jun.park@alumni.iu.edu}
}
\keyword{bssmle}
