% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation_functions.R
\name{ilr}
\alias{ilr}
\alias{slr}
\title{Log-Ratio transformations for interval responses}
\usage{
ilr(simplex)

slr(simplex)
}
\arguments{
\item{simplex}{A numeric vector that is a 2-simplex (3 elements that sum to 1)
or a dataframe where each of the rows is a 2-simplex.}
}
\value{
A numeric vector with 2 elements, the unbounded interval location and
width, or a dataframe where each of the rows is a numeric vector with these 2
elements.
}
\description{
Transform interval responses from the simplex space to the unbounded space
using either Isometric Log-Ratio (ILR) or Sum Log-Ratio (SLR)
transformations, as described by Smithson & Broomell (2024).
These transformations preserve the dimensional conceptualization of the
interval responses in terms of a location and a width.
See also \code{\link[=inv_ilr]{inv_ilr()}}, \code{\link[=inv_slr]{inv_slr()}} for the inverse transformations.

\strong{ILR}

The ILR transformation equations are:
\deqn{x_{loc} = \sqrt{\frac{1}{2}} \log\left(\frac{x_1}{x_3}\right)}
\deqn{x_{wid} = \sqrt{\frac{2}{3}} \log\left(\frac{x_2}{\sqrt{x_1 x_3}}\right)}

\strong{SLR}

The SLR transformation equations are:
\deqn{x_{loc} = \log\left(\frac{x_1}{x_3}\right)}
\deqn{x_{wid} = \log\left(\frac{x_2}{x_1 + x_3}\right)}

where \eqn{(x_1, x_2, x_3)} is the interval response in the simplex format
and \eqn{(x_{loc}, x_{wid})} are the transformed values representing the
unbounded location and width.
}
\examples{
# Generate some simplex data
simplex <- data.frame(rbind(c(.1, .2, .7), c(.4, .5, .1)))

# ILR transformation
ilr(simplex)

# SLR transformation
slr(simplex)


}
\references{
Smithson, M., & Broomell, S. B. (2024). Compositional data analysis tutorial.
Psychological Methods, 29(2), 362–378.
}
\seealso{
\code{\link[=inv_ilr]{inv_ilr()}}, \code{\link[=inv_slr]{inv_slr()}}
}
