% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_level0.R
\name{merge_level0}
\alias{merge_level0}
\title{Merge Multiple Level-0 files into a Single Table for Processing}
\usage{
merge_level0(
  FILENAME = "MYDATA",
  level0.catalog,
  file.col = "File",
  sheet = NULL,
  sheet.col = "Sheet",
  skip.rows = NULL,
  skip.rows.col = "Skip.Rows",
  num.rows = NULL,
  num.rows.col = NULL,
  date = NULL,
  date.col = "Date",
  compound.col = "Chemical.ID",
  istd.col = "ISTD",
  col.names.loc = NULL,
  col.names.loc.col = "Col.Names.Loc",
  sample.colname = NULL,
  sample.colname.col = "Sample.ColName",
  type.colname = NULL,
  type.colname.col = "Type",
  peak.colname = NULL,
  peak.colname.col = "Peak.ColName",
  istd.peak.colname = NULL,
  istd.peak.colname.col = "ISTD.Peak.ColName",
  conc.colname = NULL,
  conc.colname.col = "Conc.ColName",
  analysis.param.colname = NULL,
  analysis.param.colname.col = "AnalysisParam.ColName",
  additional.colnames = NULL,
  additional.colname.cols = NULL,
  chem.ids,
  chem.lab.id.col = "Chem.Lab.ID",
  chem.name.col = "Compound",
  chem.dtxsid.col = "DTXSID",
  catalog.out = FALSE,
  output.res = FALSE,
  INPUT.DIR = NULL,
  OUTPUT.DIR = NULL,
  verbose = TRUE
)
}
\arguments{
\item{FILENAME}{(Character) A string used to identify outputs of the function call.
(Default to "MYDATA")}

\item{level0.catalog}{A data frame describing which columns of which sheets
in which Excel files contain MS data for analysis. See details for full
explanation.}

\item{file.col}{(Character) Column name containing level-0 file names
to pull data from.}

\item{sheet}{(Character) Excel file sheet name/identifier containing
level-0 where data is to be pulled from. (Defaults to `NULL`.) (Note: Single
entry only, use only if all files have the same sheet identifier for
level-0 data.)}

\item{sheet.col}{(Character) Catalog column name containing `sheet`
information. (Default to "Sheet")}

\item{skip.rows}{(Numeric) Number of rows to skip when extracting level-0
data from the specified Excel file(s). (Defaults to `NULL`.) (Note: Single
entry only, use only if all files need to skip the same number of rows
for extracting level-0 data.)}

\item{skip.rows.col}{(Character) Catalog column name containing `skip.rows`
information. (Default to "Skip.Rows")}

\item{num.rows}{(Numeric) Number of rows to pull when extracting level-0
data from the specified Excel file(s). (Defaults to `NULL`.) (Note: Single
entry only, use only if all files need to pull the same number of rows for
extracting level-0 data.)}

\item{num.rows.col}{(Character) Catalog column name containing `num.rows`
information. (Default to `NULL`)}

\item{date}{(Character) Date of laboratory measurements. Typical format
"MMDDYY" ("MM" = 2 digit month, "DD" = 2 digit day, and "YY" = 2 digit year).
(Defaults to `NULL`.) (Note: Single entry only, use only if all files have
the same laboratory measurement date.)}

\item{date.col}{(Character) Catalog column name containing `date`
information. (Defaults to "Date")}

\item{compound.col}{(Character) Catalog column name containing `compound` 
information. (Defaults to "Chemical.ID")}

\item{istd.col}{(Character) Catalog column name containing `istd` information,
or the MS peak area for the internal standard. (Defaults to "ISTD")}

\item{col.names.loc}{(Numeric) Row location of data column names. (Defaults to 
'NULL'.) (Note: Single entry only, use only if all files have column names 
in the same row location, typically the first row.)}

\item{col.names.loc.col}{(Character) Catalog column name containing `col.names.loc`
information. (Defaults to "Col.Names.Loc")}

\item{sample.colname}{(Character) Column name of level-0 data containing
sample information. (Defaults to `NULL`.) (Note: Single entry only, use only
if all files use the same column name for sample names when extracting
level-0 data.)}

\item{sample.colname.col}{(Character) Catalog column name containing 
`sample.colname` information. (Defaults to "Sample.ColName")}

\item{type.colname}{(Character) Column name of the level-0 data containing
the type of sample. (Defaults to `NULL`.) (Note: Single entry only, use
only if all files use the same column name for sample type information
when extracting level-0 data.)}

\item{type.colname.col}{(Character) Catalog column name containing
`type.colname` information. (Defaults to "Type".)}

\item{peak.colname}{(Character) Column name of the level-0 data containing
the analyte Mass Spectrometry peak area. (Defaults to `NULL`.)
(Note: Single entry only, use only if all files use the same column name
for analyte peak area information when extracting level-0 data.)}

\item{peak.colname.col}{(Character) Catalog column name containing
`peak.colname` information. (Defaults to "Peak.ColName")}

\item{istd.peak.colname}{(Character) Column name of the level-0 data
containing the internal standard Mass Spectrometry peak area. (Note: Single
entry only, use only if all files use the same column name for internal
standard MS peak area information when extracting level-0 data.)}

\item{istd.peak.colname.col}{(Character) Catalog column name containing
`istd.peak.colname` information. (Defaults to "ISTD.Peak.ColName")}

\item{conc.colname}{(Character) Column name of the level-0 data containing
intended concentrations for calibration curves. (Defaults to `NULL`.)
(Note: Single entry only, use only if all files use the same column name
for intended concentration information when extracting level-0 data.)}

\item{conc.colname.col}{(Character) Catalog column name containing 
`conc.colname` information. (Defaults to "Conc.ColName")}

\item{analysis.param.colname}{(Character) Column name of the level-0 data
containing Mass Spectrometry instrument parameters for the analyte.
(Defaults to `NULL`.) (Note: Single entry only, use only if all files use
the same column name for analysis parameter information when extracting
level-0 data.)}

\item{analysis.param.colname.col}{(Character) Catalog column name containing
`analysis.param.colname` information. (Defaults to "AnalysisParam.ColName")}

\item{additional.colnames}{Additional columns from the level-0 data files to
pull information from when extracting level-0 data and include in the
compiled level-0 returned from `merge_level0`. (Defaults to `NULL`.)}

\item{additional.colname.cols}{Catalog column name(s) containing 
`additional.colnames` information, (Defaults to `NULL`.)}

\item{chem.ids}{(Data frame) A data frame containing basic chemical
identification information for tested chemicals.}

\item{chem.lab.id.col}{(Character) Column in `chem.ids` containing
the compound/chemical identifier used by the laboratory in level-0 measured
data. (Defaults to "Chem.Lab.ID")}

\item{chem.name.col}{(Character) `chem.ids` column name containing the
"standard" chemical name to use for annotation of the compiled level-0
returned from `merge_level0`. (Defaults to "Compound")}

\item{chem.dtxsid.col}{(Character) `chem.ids` column name containing EPA's
DSSTox Structure ID (\url{http://comptox.epa.gov/dashboard})
(Defaults to "DTXSID")}

\item{catalog.out}{(Logical) When set to \code{TRUE}, the data frame 
specified in \code{level0.catalog} will be exported to the user's per-session 
temporary directory or \code{OUTPUT.DIR} (if specified) as a .tsv file.
(Defaults to \code{FALSE}.)}

\item{output.res}{(Logical) When set to \code{TRUE}, the result 
table (level-0) will be exported to the user's per-session temporary directory
or \code{OUTPUT.DIR} (if specified) as a .tsv file. (Defaults to \code{FALSE}.)}

\item{INPUT.DIR}{(Character) Path to the directory where the Excel files 
with level-0 data exist. If not specified, looking for the files
in the current working directory. (Defaults to \code{NULL}.)}

\item{OUTPUT.DIR}{(Character) Path to the directory to save the output file. 
If \code{NULL}, the output file will be saved to the user's per-session temporary
directory. (Defaults to \code{NULL}.)}

\item{verbose}{(\emph{logical}) Indicate whether printed statements should be shown.
(Default is TRUE.)}
}
\value{
\item{data.frame}{A data.frame in standardized level-0 format}
}
\description{
This function reads multiple Excel files containing mass-spectrometry (MS) data
and extracts the chemical sample data from the specified
sheets. The argument `level0.catalog` is a table that
provides the necessary information to find the data for each chemical. The
primary data of interest are the analyte peak area, the internal standard
peak area, and the target concentration for calibration curve (CC) samples.
The argument `data.label` is used to annotate this particular mapping of level-0
files into data ready to be organized into a level-1 file.
}
\details{
Unless specified to be a single value for all the files, for example sheet="Data",
the argument `level0.catalog` should be a data frame with the following columns:
\tabular{rr}{
  File \tab The Excel filename to be loaded\cr
  Sheet \tab The name of the Sheet to examine within in the Excel file\cr
  Skip.Rows \tab How many rows should be skipped on the sheet to get usable column names\cr
  Date \tab The date the measurements were made\cr
  Chemical.ID \tab The laboratory chemical identity\cr
  ISTD \tab The internal standard used\cr
  Col.Names.Loc \tab The row locations of the column names\cr
  Sample.ColName \tab The column name on the sheet that contains sample identity\cr
  Type.ColName \tab The column name on the sheet that contains the type of sample\cr
  Peak.ColName \tab The column name on the sheet that contains the analyte MS peak area \cr
  ISTD.Peak.ColName \tab The column name on the sheet that contains the internal standard MS peak area\cr
  Conc.ColName \tab The column name on the sheet that contains the intended concentration for calibration curves \cr
  AnalysisParam.ColName \tab The column name on the sheet that contains the MS instrument parameters for the analyte\cr
}
Columns with names ending in ".ColName" indicate the columns to be extracted
from the specified Excel file and sheet containing level-0 data.

If the output level-0 file is chosen to be exported and an output directory 
is not specified, it will be exported to the user's R session temporary directory. 
This temporary directory is a per-session directory whose path can be found with
the following code: \code{tempdir()}. For more details, see 
\url{https://www.collinberke.com/til/posts/2023-10-24-temp-directories/}.

As a best practice, \code{INPUT.DIR} (when importing a .tsv file) and/or 
\code{OUTPUT.DIR} shoud be specified to simplify the process of importing and
exporting files. This practice ensures that the exported files can easily be 
found and will not be exported to a temporary directory.
}
\examples{

# Create level0.catalog data.frame
# Will need to retrieve "Hep_745_949_959_082421_final.xlsx" file from 
# inst/extdata/Kreutz-Clint and save it to desired directory.
# Note XLSX file does not need to be saved to current working directory. 
catalog <- create_catalog(file = "Hep_745_949_959_082421_final.xlsx",
                          sheet = "Data063021",
                          skip.rows = 44,
                          num.rows = 30,
                          date = "063021",
                          compound = "745",
                          istd = "MFBET",
                          sample = "Name",
                          type = "Type",
                          peak = "Area...13",
                          istd.peak = "Resp....16",
                          conc = "Final Conc....11",
                          analysis.param = "Exp. Conc....10",
                          col.names.loc = 2)
# Create chem.ids data.frame
chem.ids <- data.frame("Chem.Lab.ID" = "745",
                       "Compound" = "(Heptafluorobutanoyl)pivaloylmethane",
                       "DTXSID" = "DTXSID3066215")
# Create level0 data.frame       
# Will need to replace <PATH TO FILE> with chosen desired directory containing
# XLSX file from above.                  
level0 <- merge_level0(level0.catalog = catalog,
             INPUT.DIR = system.file("extdata/Kreutz-Clint",package = "invitroTKstats"),
             istd.col = "ISTD.Name",
             type.colname.col = "Type.ColName",
             num.rows.col = "Number.Data.Rows",
             chem.ids = chem.ids,
             catalog.out = FALSE,
             output.res = FALSE) # do not auto-save the file

}
\author{
John Wambaugh
}
