% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{pseudo_cvt}
\alias{pseudo_cvt}
\title{Creating a simple test CvT dataset}
\usage{
pseudo_cvt(
  params = c(Clint = 10, Q_gfr = 0.31, Q_totli = 0.743, Fup = 0.2, Vdist = 1.2, Fgutabs =
    0.75, kgutabs = 0.3, Rblood2plasma = 0.8, Frec = 0.95),
  time = seq(0, 30, by = 0.5),
  dose = 100,
  route = c("oral", "iv"),
  medium = c("blood", "plasma", "excreta"),
  N = 4,
  var = 0.5
)
}
\arguments{
\item{params}{A named numeric vector of model parameter values.}

\item{time}{A numeric vector of times, reflecting the time point when
concentration is measured after the corresponding single bolus dose. Must be
same length as `dose` and `iv.dose`, or length 1.}

\item{dose}{A numeric vector of doses, reflecting single bolus doses
administered at time 0. Must be same length as `time` and `iv.dose`, or
length 1. In this model, it is expected that this value represents a measurement
of radioactive particles from a radiolabeling experiment.}

\item{route}{A character vector, reflecting the route of administration of
each single bolus dose: `'oral'` or `'iv'`.  Must be same length as `time`
and `dose`, or length 1.}

\item{medium}{A character vector reflecting the medium in which each resulting
concentration is to be calculated: "blood" or "plasma". Default is "plasma".
Must be same length as `time` and `dose`, or length 1.}

\item{N}{Numeric, positive and non-zero integer. Number of individual subjects.}

\item{var}{Numeric between 0 and 1. Describes variation in the measurements.}
}
\value{
A data frame with concentration over time data.
}
\description{
Creating a simple test CvT dataset
}
