% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supplementary_add.R
\name{supplementary_add}
\alias{supplementary_add}
\title{Add supplementary rows to an IO/SUT table}
\usage{
supplementary_add(data_table, supplementary_data, supplementary_names = NULL)
}
\arguments{
\item{data_table}{A SIOT, use, supply, or margins table (key column + numeric columns).}

\item{supplementary_data}{A data frame (or tibble) of one or more rows to add. It may already
contain a key column (first column). Otherwise, provide
\code{supplementary_names} or the keys will be auto-generated. All other
column names must match \code{data_table}.}

\item{supplementary_names}{Optional character vector of row names for the key column; length
must equal \code{nrow(supplementary_data)}. Ignored if a key column is
already present.}
}
\value{
A \code{data.frame} with the rows of \code{supplementary_data} bound to
\code{data_table} and aligned to its key and numeric columns.
}
\description{
Append supplementary indicators (e.g., emissions coefficients) as new
rows to a symmetric input–output table (SIOT), use, supply, or margins
table. This is a light wrapper around \code{\link[=rows_add]{rows_add()}}.
}
\details{
Column names in \code{supplementary_data} must match the numeric columns of
\code{data_table}. If the key column is missing, it is created from
\code{supplementary_names} or auto-generated as \code{supplementary_row_#}.

When a household final consumption column is present (e.g.,
\code{final_consumption_households}, \code{P3_S14}), new rows get \code{0} in that
column if the supplied values are \code{NA}.

For terminology, see Eurostat’s \emph{Manual of Supply, Use and Input-Output
Tables}.
(Eurostat, 2008; ISBN 978-92-79-04704-3)
}
\examples{
de_io <- iotable_get()
CO2_coefficients <- data.frame(
  agriculture_group = 0.2379,
  industry_group = 0.5172,
  construction = 0.0456,
  trade_group = 0.1320,
  business_services_group = 0.0127,
  other_services_group = 0.0530
)
CH4_coefficients <- data.frame(
  agriculture_group = 0.0349,
  industry_group = 0.0011,
  construction = 0,
  trade_group = 0,
  business_services_group = 0,
  other_services_group = 0.0021
)
CO2 <- cbind(
  data.frame(iotables_row = "CO2"),
  CO2_coefficients
)
CH4 <- cbind(
  data.frame(iotables_row = "CH4_coefficients"),
  CH4_coefficients
)
de_coeff <- input_coefficient_matrix_create ( iotable_get() )
emissions <- rbind (CO2, CH4)

# Check with the Eurostat Manual page 494:
supplementary_add(de_io, emissions)
}
\seealso{
Other iotables processing functions: 
\code{\link{conforming_vector_create}()},
\code{\link{empty_remove}()},
\code{\link{household_column_find}()},
\code{\link{household_column_get}()},
\code{\link{iotable_year_get}()},
\code{\link{key_column_create}()},
\code{\link{matrix_round}()},
\code{\link{output_get}()},
\code{\link{primary_input_get}()},
\code{\link{rows_add}()},
\code{\link{total_tax_add}()},
\code{\link{vector_transpose_longer}()},
\code{\link{vector_transpose_wider}()}
}
\concept{iotables processing functions}
