% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/producer.R
\name{Producer}
\alias{Producer}
\title{A Class for sending signals to a source}
\description{
A Class for sending signals to a source

A Class for sending signals to a source
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Producer-new}{\code{Producer$new()}}
\item \href{#method-Producer-setSource}{\code{Producer$setSource()}}
\item \href{#method-Producer-getSource}{\code{Producer$getSource()}}
\item \href{#method-Producer-fire}{\code{Producer$fire()}}
\item \href{#method-Producer-fireEval}{\code{Producer$fireEval()}}
\item \href{#method-Producer-fireDoCall}{\code{Producer$fireDoCall()}}
\item \href{#method-Producer-fireCall}{\code{Producer$fireCall()}}
\item \href{#method-Producer-clone}{\code{Producer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Producer-new"></a>}}
\if{latex}{\out{\hypertarget{method-Producer-new}{}}}
\subsection{Method \code{new()}}{
Creates a Producer object linked to the \code{source}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Producer$new(source)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{A source.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Producer-setSource"></a>}}
\if{latex}{\out{\hypertarget{method-Producer-setSource}{}}}
\subsection{Method \code{setSource()}}{
Setter for source.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Producer$setSource(source)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{A source.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Producer-getSource"></a>}}
\if{latex}{\out{\hypertarget{method-Producer-getSource}{}}}
\subsection{Method \code{getSource()}}{
Getter for source.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Producer$getSource()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Producer-fire"></a>}}
\if{latex}{\out{\hypertarget{method-Producer-fire}{}}}
\subsection{Method \code{fire()}}{
Sends a signal to the source with associates object \code{obj}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Producer$fire(signal, obj = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{signal}}{A string signal to send.}

\item{\code{obj}}{The object to associate with the signal.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Producer-fireEval"></a>}}
\if{latex}{\out{\hypertarget{method-Producer-fireEval}{}}}
\subsection{Method \code{fireEval()}}{
Signals for execution of the expression \code{obj} with values from
      the environment (or list) \code{env} substituted in.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Producer$fireEval(expr, env)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expr}}{An expression to evaluate.}

\item{\code{env}}{An environment or list for substitution}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Producer-fireDoCall"></a>}}
\if{latex}{\out{\hypertarget{method-Producer-fireDoCall}{}}}
\subsection{Method \code{fireDoCall()}}{
Signals for execution of the function whose string value is \code{name}
      with the parameters in list \code{param}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Producer$fireDoCall(name, param)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{the name of the function}

\item{\code{param}}{A list of function parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Producer-fireCall"></a>}}
\if{latex}{\out{\hypertarget{method-Producer-fireCall}{}}}
\subsection{Method \code{fireCall()}}{
Signals for execution of the function whose string value is \code{name}
      with the parameters \code{...}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Producer$fireCall(name, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{the name of the function}

\item{\code{...}}{The arguments to the function.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Producer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Producer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Producer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
