% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipft.R
\name{ipfProbabilistic}
\alias{ipfProbabilistic}
\title{This function implements a probabilistic algorithm}
\usage{
ipfProbabilistic(train_fgp, train_pos, group_cols = NULL, groups = NULL,
  k = 3, FUN = sum, delta = 1, ...)
}
\arguments{
\item{train_fgp}{a data frame containing the fingerprint vectors of the training set}

\item{train_pos}{a data frame containing the positions of the training set observations}

\item{group_cols}{a character vector with the names of the columns to be used as the criteria
to group the fingerprints. By default the groups will be created using all
the columns available in the train_pos data frame.}

\item{groups}{a numeric vector of length = nrow(train) containing the group index
for the training vectors}

\item{k}{the k parameter for the algorithm (number of similar neighbors)}

\item{FUN}{function to compute the similarity measurement. Default is 'sum'}

\item{delta}{parameter delta}

\item{...}{additional parameters for provided function FUN}
}
\value{
An S3 object of class ipfModel, with the following properties:
                 params ->     a list with the parameters passed to the function
                 data   ->     a list with the fingerprints probabilistic parameters
                               (means and standard deviations) and its locations
}
\description{
This function implements a probabilistic algorithm
}
\examples{

    groups <- ipfGroup(ipftrain, X, Y)
    model <- ipfProbabilistic(ipftrain[, 1:168], ipftrain[, 169:170], groups = groups)

\dontrun{
    model <- ipfProbabilistic(ipftrain[, 1:168], ipftrain[, 169:170], k = 9, delta = 10)
}

}
