% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irtpro.R
\name{est_irtpro}
\alias{est_irtpro}
\title{Item Calibration via IRTPRO}
\usage{
est_irtpro(
  x = NULL,
  model = "3PL",
  target_dir = getwd(),
  D = 1,
  analysis_name = "irtpro_calibration",
  items = NULL,
  examinee_id_var = NULL,
  group_var = NULL,
  reference_group = NULL,
  estimation_method = c("BAEM", "ADQ", "MHRM", "MCMC"),
  estimation_args = list(`E-Step` = c(500, 1e-05), SE = "S-EM", `M-Step` = c(500, 1e-09),
    Quadrature = c(49, 6), SEM = 0.001, SS = 1e-05),
  scoring_method = c("EAP", "MAP"),
  scoring_args = list(Mean = 0, SD = 1),
  misc_args = list(Decimal = 4, Processors = 1, `Min Exp` = 1),
  print_extra = c("StdRes", "CTLD", "M2", "GOF", "Loadings", "P-Nums", "Diagnostic"),
  constraints = NULL,
  priors = data.frame(model = c("1PL", "2PL", "2PL", "3PL", "3PL", "3PL"), parameter =
    c("Intercept[0]", "Slope[0]", "Intercept[0]", "Slope[0]", "Intercept[0]",
    "Guessing[0]"), prior_dist = c("Normal", "Lognormal", "Normal", "Lognormal",
    "Normal", "Beta"), prior_par_1 = c(0, 0, 0, 0, 0, 4), prior_par_2 = c(2, 1, 2, 1, 2,
    16)),
  overwrite = FALSE,
  show_output_on_console = TRUE,
  irtpro_exe_dir = file.path("C:/Program Files/IRTPRO 6.0")
)
}
\arguments{
\item{x}{Either a \code{data.frame}, \code{matrix} or
  \code{\link{Response_set-class}} object.

  It is assumed that item values start from 0 and goes to number of distinct
  categories minus one. So, for example, for a polytomous items with four
  categories, the score values are assumed to be 0, 1, 2, 3. Recode the data
  to follow this pattern.}

\item{model}{A string or a vector of strings to specify the psychometric
model of the items. Either provide a single model for all items or provide
a vector with the same length as the number of \code{items} where each
value is one of the following: One-parameter logistic model (\code{"1PL"}),
Two-parameter logistic model (\code{"2PL"}), three-parameter logistic model
(\code{"3PL"}), Generalized Partial Credit model (\code{"GPCM2"}), Graded
Response Model (\code{"GRM"}).}

\item{target_dir}{The directory/folder where the IRTPRO analysis and data
files will be saved. The default value is the current working directory,
i.e. \code{get_wd()}.}

\item{D}{Scaling constant. The default value is \code{1}. If, for
\code{"2PL"}, \code{"3PL"} or \code{"GRM"} models, the item parameters
needs to be converted to the commonly used normal scale where \code{D =
1.7} or \code{D = 1.702}, change this value. The item discrimination
parameters estimated by IRTPRO will be divided to \code{D} to get
parameters on the new scale.}

\item{analysis_name}{A short file name that will be used for the data files
created for the analysis.}

\item{items}{A vector of column names of the \code{x} that
represents the responses. Default value is \code{NULL} where all items
in \code{x} are assumed to be entering the calibration.}

\item{examinee_id_var}{The column name or number that contains individual
subject IDs. If none is provided (i.e. \code{examinee_id_var = NULL}), the
program will check whether the data provided has row names.}

\item{group_var}{The column name or number that contains group membership
information if multi-group calibration is desired. Currently, this function
cannot read multi-group calibration results. The default value is
\code{NULL}, where no multi-group analysis will be performed.}

\item{reference_group}{Represent which group's ability distribution will be
set to mean = 0 and standard deviation = 1. For example, if the value is 1,
then the group whose code is 1 will have ability distribution with mean 0
and standard deviation 1. The default value is \code{NULL}.}

\item{estimation_method}{A string that can take one of the following values:
\code{"BAEM"} (Bock-Aitkin), \code{"ADQ"} (Adaptive Quadrature).
The methods \code{"MHRM"} (Metropolis-Hastings Robbins-Monro) and
\code{"MHRM"} are not available at this time via this program.}

\item{estimation_args}{A list with named arguments that will specify the
  estimation. Please use one of the following list templates for each
  estimation method.
  \describe{
    \item{\code{"BAEM"}}{\code{list(`E-Step` = c(500, 1e-005),
                                    SE = "S-EM",
                                    `M-Step` = c(500, 1e-009),
                                    Quadrature = c(49, 6),
                                    SEM = 0.001,
                                    SS = 1e-005)}}
    \item{\code{"ADQ"}}{\code{list(`E-Step` = c(100, 0.001),
                                   SE = "S-EM",
                                   Quadrature = c(9, "GH"),
                                   Adaptation = "EAP",
                                   Trust = "Fast")}}
  }

For \code{"SE"} element, the options are \code{"S-EM"}, \code{"M-Step"},
\code{"Xpd"}, and \code{"Sandwich"}. See the IRTPRO manual for details.}

\item{scoring_method}{A string that can take one of the following values:
\code{"EAP"} for Expected-a-Posteriori or \code{"MAP"} for
Maximum-a-Posteriori.}

\item{scoring_args}{A list with named arguments that will specify the
scoring. The program will automatically add \code{"Score Persons"}.
Following list elements can also be specified (last two elements are
optional):
\code{list(Mean = 0, SD = 1, Minimum = <Minimum Score>,
           Maximum = <Maximum Score>)}}

\item{misc_args}{A list with named arguments that will specify the
miscellaneous arguments such as the number of decimals for the estimated
parameters, the number of processors, etc.
The following elements can be changed:
\code{list(Decimal = 4, Processors = 1, `Min Exp` = 1)}}

\item{print_extra}{A string vector specifying additional results to be
printed:
`StdRes` (Print table of standardized residuals)
`CTLD` (Compute Chen-Thissen LD and item fit statistics)
`M2` (Compute limited-information overall model fit statistics)
`GOF` (Print each item's goodness of fit frequency table)
`Loadings` (Print factor loadings)
`P-Nums` (Print parameter numbers)
`Diagnostic` (Print diagnostic information)}

\item{constraints}{A vector of sting commands for constraints section of the
syntax. It is usually used to constrain a parameter to a certain value.
Usually it has the following format:
\code{"Equal = (G1, Item Name, Parameter), (G2, Item Name, Parameter);"}
Here is an example:
\code{c(
  "Equal = (G1, Item_1, Slope[0]), (G2, Item_1, Slope[0]);",
  "Equal = (G1, Item_1, Intercept[0]), (G2, Item_1, Intercept[0]);",
  "Equal = (G1, Item_2, Slope[0]), (G2, Item_2, Slope[0]);",
  "Equal = (G1, Item_2, Intercept[0]), (G2, Item_2, Intercept[0]);")}
or:
\code{c("(Item_1, Slope[0]) = 1.3;",
        "(Item_1, Intercept[0]) = 2.1;",
        "(Item_2, Slope[0]) = 0.7;",
        "(Item_2, Intercept[0]) = -1.2;")}}

\item{priors}{A list that specifies the prior parameters. There are three
  possible options.

  The value can be \code{NULL} where no prior information will be used.

  The value can be a data frame with the following format:
  Column names: \code{item_id, parameter, prior_dist, prior_par_1,
  prior_par_2}.
  \code{item_id} column should match item IDs.
  \code{parameter} should be following one of the \code{"Slope[0]"},
  \code{"Intercept[0]"}, or \code{"Guessing[0]"}.
  \code{prior_par} column should be one of the following values:
  \code{"Lognormal"}, \code{"Normal"}, \code{"Beta"}.
  \code{prior_par_1} and \code{prior_par_2} should be numeric values for the
  prior parameters. For \code{"Normal"} or \code{"Lognormal"},
  \code{prior_par_1} can be 0 (mean) and \code{prior_par_2} can be 1
  (standard deviation.
  For \code{"Beta"}, \code{prior_par_1} can be 4 (mean) and
  \code{prior_par_2} can be 16.

  The value can be a data frame with the following format if all items
  for a model should follow the same priors:
  Column names:\code{model, parameter, prior_dist, prior_par_1, prior_par_2}.
  The \code{model} column should match the \code{model} argument of the
  function. See the \code{model} argument's description to see the available
  options.}

\item{overwrite}{If \code{TRUE} and there are already an IRTPRO analysis
files in the target path with the same name, these file will be
overwritten.}

\item{show_output_on_console}{logical (not NA), indicates whether to capture
the output of the command and show it on the R console. The default value
is \code{TRUE}.}

\item{irtpro_exe_dir}{The location of the \code{"ASCII2SSIG64.exe"} and
\code{"IRTPROx64.exe"}. The default location is
\code{file.path("C:/Program Files/IRTPRO 6.0")}.}
}
\description{
\code{est_irtpro} runs the IRTPRO in batch mode.

  This function requires IRTPRO already installed on your computer. The
  R program is designed to work on IRTPRO 6.0.

  NOTE that sometimes IRTPRO requires administrative privileges to run each
  time it is opened. You can reopen R or RStudio with administrator
  privileges (right click R or RStudio icon in start menu and select 'More' >
  'Run as administrator') to prevent IRTPRO to ask administrator permission
  each time it is run.
}
\examples{
\dontrun{
resp <- sim_resp(generate_ip(n = 15), rnorm(200), prop_missing = .2)
irtpro_calib <- est_irtpro(x = resp, model = "3PL",
                           target_dir = file.path("C:/temp/irtpro1"),
                           overwrite = TRUE)

n_examinee <- 500
resp <- sim_resp(generate_ip(model = sample(c("3PL", "GPCM2"), 20, T)),
                 rnorm(n_examinee), prop_missing = .2)
resp <- cbind.data.frame(examinee_id = paste0("Ex", 1:n_examinee),
                         group = sample(c("A", "B"), n_examinee, TRUE),
                         resp)
irtpro_calib_mixed <- est_irtpro(
  x = resp,
  items = NULL,
  examinee_id_var = "examinee_id",
  group_var = "group",
  target_dir = file.path("C:/temp/irtpro2"),
  overwrite = TRUE)
}

}
\author{
Emre Gonulates
}
