% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dyn_2D.R
\name{plot_dyn_2D}
\alias{plot_dyn_2D}
\title{plot sweep.dyn_2D outputs}
\usage{
plot_dyn_2D(
  workdir,
  sweep_dir_name,
  time_unit = NULL,
  time_range = NULL,
  hidden_boxes = NULL,
  return_as_print = TRUE,
  free_y_scale = TRUE,
  swap_sweep_params = FALSE,
  show.delta_drift = FALSE,
  time_as_log10 = TRUE
)
}
\arguments{
\item{workdir}{Working directory of \strong{\emph{isobxr excel master file}}
and where output files will be stored if exported by user.
(character string)}

\item{sweep_dir_name}{Full name of sweep.dyn_2D SERIES directory (character string)}

\item{time_unit}{Time unit to use on plot if different from native time unit. \cr
Character string, to be selected among the following: \cr
\emph{micros, ms, s, min, h, d, wk, mo, yr, kyr, Myr, Gyr} \cr
Default is NULL.}

\item{time_range}{Time range to zoom on as vector of two values, such as: c(0,100) \cr
Values in displayed time units. \cr
Default is NULL.}

\item{hidden_boxes}{List of boxes to hide from plots, as a vector of character strings. \cr
For instance c("SOURCE", "SINK"). \cr
Default is NULL.}

\item{return_as_print}{If TRUE, prints delta and size vs. time plots in a single page figure on R. \cr
If FALSE, returns separately delta and size vs. time plots as list of editable R objects. \cr
Default is TRUE.}

\item{free_y_scale}{If TRUE, frees Y axis scale. \cr
Default is TRUE.}

\item{swap_sweep_params}{If TRUE, swaps the sweep parameter 1 and 2 representations
from color to facet scales. \cr
Default is FALSE.}

\item{show.delta_drift}{If TRUE, displays drift of delta values from t0.}

\item{time_as_log10}{If TRUE, uses logarithmic time scale in plot. \cr
Default is TRUE.}
}
\value{
A set of plots showing the evolution of delta and sizes with time.
}
\description{
A function to plot delta vs time from the sweep.dyn_2D runs
}
