% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isotopeAssignmentModel.R
\name{isotopeAssignmentModel}
\alias{isotopeAssignmentModel}
\title{Isotope assignment model function}
\usage{
isotopeAssignmentModel(
  ID,
  isotopeValue,
  SD_indv = 0,
  precip_raster,
  precip_SD_raster,
  additionalModels = FALSE,
  additionalModel_name = "CombinedIsotope-OtherModelAssignments",
  savePath = FALSE,
  nClusters = FALSE
)
}
\arguments{
\item{ID}{ID value or vector of values (for naming assignment model layers). If missing, will count from 1.}

\item{isotopeValue}{Isotope precipitation value or vector of values.}

\item{SD_indv}{error associated with transfer function fit. Value or vector of values. If missing, will assume value of 0.}

\item{precip_raster}{precipitation isoscape raster.}

\item{precip_SD_raster}{precipitation isoscape standard deviation raster.}

\item{additionalModels}{optional additional model raster object (e.g. an SDM, rasterized range map, or stack thereof). If specified, function will return isotope assignment rasters and the product of these additionalModels and each assignmentRaster.}

\item{additionalModel_name}{optional filename for additionalModel .grd savepath}

\item{savePath}{If specified, function will save results to this path as a '.grd' file.}

\item{nClusters}{integer of cores to run in parallel with doParallel. Default FALSE.}
}
\description{
Creates isotope assignment models projections of probable origin. Results returned as a RasterStack, with layer names corresponding to individual ID.
}
\examples{
myiso <- rasterFromXYZ(isoscape)
raster::plot(myiso)
myiso_sd <- rasterFromXYZ(isoscape_sd)
df <- data.frame(
         ID = paste0("Example.", 1:3),
         isotopeValue = c(-100, -80, -50),
         SD_indv = rep(5, 3)
         )
assignmentModels <- isotopeAssignmentModel(
                        ID = df$ID,
                        isotopeValue = df$isotopeValue,
                        SD_indv = df$SD_indv,
                        precip_raster = myiso,
                        precip_SD_raster = myiso_sd
                        )
raster::plot(assignmentModels)

# Add additionalModels:
range_raster <- myiso
range_raster[] <- as.numeric( 1:ncell(myiso) \%\% 60 >= 10)
plot(range_raster)

sdm_raster <- myiso
sdm_raster[] <- (1:ncell(sdm_raster))^2
sdm_raster <- sdm_raster / raster::cellStats(sdm_raster, "sum")
plot(sdm_raster)

extraModels <- raster::stack(range_raster, sdm_raster)
assignmentModels <- isotopeAssignmentModel(
                        ID = paste0("Combo.",df$ID),
                        isotopeValue = df$isotopeValue,
                        SD_indv = df$SD_indv,
                        precip_raster = myiso,
                        precip_SD_raster = myiso_sd,
                        additionalModels = extraModels
                        )
raster::plot(assignmentModels)



}
