% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isocubes.R
\name{isocubesGrob}
\alias{isocubesGrob}
\title{Create a grob of isocubes representing the voxels at the given coordiantes}
\usage{
isocubesGrob(
  coords,
  fill = NULL,
  fill_left = NULL,
  fill_right = NULL,
  intensity = c(1, 0.3, 0.7),
  size = 5,
  x = 0.5,
  y = 0.5,
  col = "black",
  default.units = "mm",
  xyplane = "flat",
  handedness = "right",
  verbosity = 0,
  ...
)
}
\arguments{
\item{coords}{data.frame of x,y,z coordinates for the cubes (integer coordinates)}

\item{fill}{fill colour for the top face of cube. Default: NULL will attempt
to use the 'fill' colour in the coords data.frame, otherwise 'grey50'}

\item{fill_left, fill_right}{fill colours for left and fight faces of
cube.}

\item{intensity}{c(1, 0.3, 0.6) Intensity shading for \code{fill} for the 
top, left and right faces respectively.  Note: this setting has no effect 
 on the shading of the left face if \code{fill_left} has been set 
 explicitly by the user; same for the right face.}

\item{size}{dimensions of cube i.e. the length of the vertical edge of the cube.
Default: 5mm}

\item{x, y}{the origin of the isometric coordinate system.
If these values are given as vanilla floating point values, they 
will be interpreted as 'npc' units, otherwise a valid grid unit 
object must be supplied.
By default the origin is the middle of the graphics device 
i.e. \code{(x, y) = (0.5, 0.5)}}

\item{col}{Stroke colour for outline of cube faces. Default: black. If \code{NA}
then no outlines will be drawn.  If negative, then outline colour
will be the same as the face colour.}

\item{default.units}{Default unit for size of a cube is 'mm'}

\item{xyplane}{How is the xyplane oriented with respect to the unit isometric
cube?.  "left", "right", "flat" (or "top").
Default: "flat".}

\item{handedness}{How is the z-axis positioned with respect to the xy-plane?
I.e. is this a right-handed or left-handed coordinate system?
Default: "right"}

\item{verbosity}{Verbosity level. Default: 0}

\item{...}{other values passed to \code{gpar()} to set the graphical
parameters e.g. \code{lwd} and \code{col} for the linewidth and colour
of the outline stroke for each cube face.}
}
\value{
grid \code{grob} object
}
\description{
Create a grob of isocubes representing the voxels at the given coordiantes
}
\examples{
obj_sphere <- gen_sphere(r = 10)
fill <- rainbow(nrow(obj_sphere))
isocubesGrob(obj_sphere, fill = fill, size = 2) |>
  grid::grid.draw()

# The 'obj_organic' data.frame includes a 'fill' column which will be
# used by default
grid::grid.newpage()
isocubesGrob(obj_organic, size = 2) |>
  grid::grid.draw()
}
