% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{pit}
\alias{pit}
\alias{pit.idr}
\alias{pit.data.frame}
\title{Probability integral transform (PIT)}
\usage{
pit(predictions, y, randomize = TRUE, seed = NULL)

\method{pit}{idr}(predictions, y, randomize = TRUE, seed = NULL)

\method{pit}{data.frame}(predictions, y, randomize = TRUE, seed = NULL)
}
\arguments{
\item{predictions}{either an object of class \code{idr} (output of
\code{\link{predict.idrfit}}), or a \code{data.frame} of numeric variables. In
the latter case, the PIT is computed using the empirical distribution of
the variables in \code{predictions}.}

\item{y}{a numeric vector of obervations of the same length as the number of
predictions.}

\item{randomize}{PIT values should be randomized at discontinuity points of the
predictive CDF (e.g. at zero for precipitation forecasts). Set \code{
randomize = TRUE} to randomize.}

\item{seed}{argument to \code{set.seed} for random number generation (if
\code{randomize} is \code{TRUE}).}
}
\value{
Vector of PIT values.
}
\description{
Computes the probability integral transform (PIT) of IDR or raw
  forecasts.
}
\examples{
data("rain")
require("graphics")

## Postprocess HRES forecast using data of 4 years

X <- rain[1:(4 * 365), "HRES", drop = FALSE]
y <- rain[1:(4 * 365), "obs"]

fit <- idr(y = y, X = X)

## Assess calibration of the postprocessed HRES forecast using data of next 4
## years and compare to calibration of the raw ensemble

data <- rain[(4 * 365 + 1):(8 * 365), "HRES", drop = FALSE]
obs <- rain[(4 * 365 + 1):(8 * 365), "obs"]
predictions <- predict(fit, data = data)
idrPit <- pit(predictions, obs, seed = 123)

rawData <- rain[(4 * 365 + 1):(8 * 365), c("HRES", "CTR", paste0("P", 1:50))]
rawPit <- pit(rawData, obs, seed = 123)

hist(idrPit, xlab = "Probability Integral Transform",
  ylab = "Density", freq = FALSE, main = "Postprocessed HRES")
hist(rawPit, xlab = "Probability Integral Transform",
  ylab = "Density", freq = FALSE, main = "Raw ensemble")
}
\references{
Gneiting, T., Balabdaoui, F. and Raftery, A. E. (2007), 'Probabilistic
forecasts, calibration and sharpness', Journal of the Royal Statistical
Society: Series B (Statistical Methodology) 69(2), 243-268.
}
\seealso{
\code{\link{predict.idrfit}}
}
