% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-hmcellfunlabel.R
\name{cell_fun_label}
\alias{cell_fun_label}
\title{ComplexHeatmap cell function to label heatmap cells}
\usage{
cell_fun_label(
  m,
  prefix = "",
  suffix = "",
  cex = 1,
  col_hm = NULL,
  outline = FALSE,
  abbrev = FALSE,
  show = NULL,
  rot = 0,
  sep = "\\n",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{m}{\code{numeric} matrix or \code{list} of \code{matrix} objects. The
first \code{matrix} object must be \code{numeric} and compatible
with the color function \code{col_hm}.}

\item{prefix, suffix}{\code{character} vectors that define a prefix and
suffix for each value in \code{m} for each cell.}

\item{cex}{\code{numeric} adjustment for the fontsize used for each label,
which is multiplied by the default \code{fontsize=10} to determine
the fontsize.}

\item{col_hm}{\code{function} as returned by \code{circlize::colorRamp2()} which
should be the same function used to create the heatmap}

\item{outline}{\code{logical} indicating whether to draw an outline around
each heatmap cell}

\item{abbrev}{\code{logical} indicating whether numeric values should
be abbreviated using \code{jamba::asSize(..., kiloSize=1000)} which
effectively reduces large numbers to \code{k} for thousands, \code{M} for
millions (M for Mega), \code{G} for billions (G for Giga), etc.}

\item{show}{\code{integer} used when \code{m} is supplied as a \code{list} of matrices,
in which case \code{show} is used to define which values should be used
as cell labels. By default, all matrices are used.}

\item{rot}{\code{numeric} value used to rotate cell label text, default 0
is horizontal.}

\item{sep}{\code{character} string, default \code{"\\n"} newline, used when
there are multiple labels per cell, which also requires
\code{m} as a list, and \code{show} is \code{NULL} or has multiple values.}

\item{verbose}{\code{logical} indicating whether to print verbose output,
specifically printing label information for position \verb{(1, 1)}.
This output will only be seen when rendering or building the
Heatmap object.}

\item{...}{additional arguments are ignored.}
}
\value{
\code{function} sufficient to use as input to
\code{ComplexHeatmap::Heatmap()} argument \code{cell_fun}.
}
\description{
ComplexHeatmap cell function to label heatmap cells
}
\details{
This function serves as a convenient method to add text
labels to each cell in a heatmap produced by
\code{ComplexHeatmap::Heatmap()}, via the argument \code{cell_fun}.

Note that this function requires re-using the specific color
function used for the heatmap in the call to
\code{ComplexHeatmap::Heatmap()}.

This function is slightly unique in that it allows multiple
labels, if \code{m} is supplied as a \code{list} of \code{matrix} objects.
In fact, some \code{matrix} objects may contain \code{character}
values with custom labels.

Cell labels are colored based upon the heatmap cell color,
which is passed to \code{jamba::setTextContrastColor()} to determine
whether to use light or dark text color for optimum contrast.

TODO: Option to supply a \code{logical} matrix to define a subset of
cells to label, for example only labels that meet a filter
criteria. Alternatively, the matrix data supplied in \code{m} can
already be filtered.

TODO: Allow some matrix values that contain \code{character} data
to use \code{gridtext} for custom markdown formatting. That process
requires a slightly different method.
}
\examples{
\dontshow{if ((check_pkg_installed("ComplexHeatmap"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

m <- matrix(stats::rnorm(16)*2, ncol=4)
colnames(m) <- LETTERS[1:4]
rownames(m) <- letters[1:4]
col_hm <- circlize::colorRamp2(breaks=(-2:2) * 2,
   colors=c("navy", "dodgerblue", "white", "tomato", "red4"))

# the heatmap can be created in one step
hm <- ComplexHeatmap::Heatmap(m,
   col=col_hm,
   heatmap_legend_param=list(
      color_bar="discrete",
      border=TRUE,
      at=-4:4),
   cell_fun=cell_fun_label(m,
      col_hm=col_hm))
ComplexHeatmap::draw(hm)

# the cell label function can be created first
cell_fun <- cell_fun_label(m,
   outline=TRUE,
   cex=1.5,
   col_hm=col_hm)
hm2 <- ComplexHeatmap::Heatmap(m,
   col=col_hm,
   cell_fun=cell_fun)
ComplexHeatmap::draw(hm2)
\dontshow{\}) # examplesIf}
}
\seealso{
Other jam heatmap functions: 
\code{\link{heatmap_column_order}()},
\code{\link{heatmap_row_order}()}
}
\concept{jam heatmap functions}
