% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-utils.R
\name{check_pkg_installed}
\alias{check_pkg_installed}
\title{Lightweight method to check if an R package is installed}
\usage{
check_pkg_installed(x, useMethod = c("packagedir", "requireNamespace"), ...)
}
\arguments{
\item{x}{\code{character} string of package or packages to test.}

\item{useMethod}{\code{character} default "packagedir" with the method
of package confirmation.
\itemize{
\item "packagedir" provides a rapid test for the presence of an R
package, without loading the package namespace.
It tests whether \code{system.file(package=x)} returns  a non-empty value,
then 'DESCRIPTION' file exists in the package directory.
It answers the question: "Is 'x' package installed?"
It does not answer: "Is 'x' package usable in the current R session?"
When \code{useMethod} also includes "requireNamespace", for any FALSE
result it will also perform a secondary check as well,
to confirm the package cannot be loaded by another mechanism.
\item "requireNamespace" uses \code{requireNamespace(x, quietly=TRUE)},
with slight benefit that it accepts multiple values for \code{x}, and
returns the result without using \code{invisible()}.
This method loads the package namespace, but does not attach it.
This method therefore takes the same time as loading the package,
in return for providing the most accurate answer to the question:
"Is 'x' package usable by this R session right now?"
}}

\item{...}{additional arguments are ignored.}
}
\value{
\code{logical} vector indicating whether each value in \code{x}
represents an installed R package. The vector is named by
packages provided in \code{x}.
}
\description{
Lightweight method to check if an R package is installed
}
\details{
There are many methods to test for an installed package.
Most approaches incur some time or resource penalty, so
\code{check_pkg_installed()} is motivated for rapid results without
loading the package namespace.

This function also accepts multiple values for \code{x} for convenience.

There are two available methods defined by \code{useMethod}:
\enumerate{
\item \code{useMethod="packagedir"} confirms:
this function represents possibly the most gentle and rapid
approach. It simply calls \code{system.file(package=x)}, for
each entry of \code{x}, then checks these requirements:
\itemize{
\item Does the package directory exist via \code{system.file(package=x)}
\item Does the package directory contain the file 'DESCRIPTION'?
\item It does not check whether the package can be loaded into
the current R session.
}
\item \code{useMethod="requireNamespace"} confirms:
\itemize{
\item \code{requireNamespace(x, quietly=TRUE)} returns TRUE
\item It therefore loads the package namespace to confirm, but
does not attach the package to the current session.
It therefore may take time and resources, despite not
altering the R environment search path.
}
}

The default behavior first tests by "packagedir", then
for any \code{FALSE} results it also tests \code{"requireNamespace"}.
}
\examples{
check_pkg_installed("methods")

check_pkg_installed(c("jamba",
   "multienrichjam",
   "venndir",
   "methods",
   "blah"))

}
\seealso{
Other jam practical functions: 
\code{\link{breakDensity}()},
\code{\link{call_fn_ellipsis}()},
\code{\link{checkLightMode}()},
\code{\link{colNum2excelName}()},
\code{\link{color_dither}()},
\code{\link{exp2signed}()},
\code{\link{getAxisLabel}()},
\code{\link{isFALSEV}()},
\code{\link{isTRUEV}()},
\code{\link{jargs}()},
\code{\link{kable_coloring}()},
\code{\link{lldf}()},
\code{\link{log2signed}()},
\code{\link{middle}()},
\code{\link{minorLogTicks}()},
\code{\link{newestFile}()},
\code{\link{printDebug}()},
\code{\link{reload_rmarkdown_cache}()},
\code{\link{renameColumn}()},
\code{\link{rmInfinite}()},
\code{\link{rmNA}()},
\code{\link{rmNAs}()},
\code{\link{rmNULL}()},
\code{\link{setPrompt}()}
}
\concept{jam practical functions}
