% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jdn.R
\name{calendar2jdn}
\alias{calendar2jdn}
\alias{jdn2calendar}
\title{jdn}
\usage{
calendar2jdn(date, jdn = c("jdn", "mjd"), calendar = c("gregorian", "julian"))

jdn2calendar(
  n,
  jdn = c("jdn", "mjd"),
  calendar = c("gregorian", "julian"),
  sep = "/"
)
}
\arguments{
\item{date}{Date to be converted. It should always include the year, month, and day.}

\item{jdn}{Select Julius Date Number or Modified Julius Date Number.}

\item{calendar}{Select whether the calendar is Gregorian or Julian.}

\item{n}{Julian Date Number or Modified Julian Date Number value.}

\item{sep}{The way the date is separated when the last date is written.}
}
\value{
* `jdn2calendar` returns a string type date.

* `calendar2jdn` returns a a numeric vector.
}
\description{
Functions for calculating Julian Date from Gregorian or Julian Date Number and functions for calculating Gregorian or Julian Date from Julian Date Number.
}
\examples{
jdn2calendar(2459216)
calendar2jdn("2021/1/1")

}
\references{
Julian Day Number - Wikipedia [ja] (JD, \url{https://ja.wikipedia.org/wiki/\%E3\%83\%A6\%E3\%83\%AA\%E3\%82\%A6\%E3\%82\%B9\%E9\%80\%9A\%E6\%97\%A5})

Fliegel, H. F., Van Flandern, T. C. (1968), \doi{10.1145/364096.364097}, "A Machine Algorithm for Processing Calendar Dates", Communications of the ACM 11, p. 657.

Hatcher, D. A. (1984, BibCode:1984QJRAS..25...53H) "Simple formulae for Julian day numbers and calendar dates, Quarterly Journal of the Royal Astronomical Society", v. 25, p. 53-55, \url{https://adsabs.harvard.edu/full/1984QJRAS..25...53H}.

Meeus, J. (1998, ISBN:0943396638) "Astronomical Algorithms. Willmann-Bell", Second English Edition.
}
