% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{predJRML}
\alias{predJRML}
\title{Prediction using \code{joineRML}}
\usage{
predJRML(model, ids, dtlong, dtsurv, ...)
}
\arguments{
\item{model}{fitted model object}

\item{ids}{value of id}

\item{dtlong}{longitudinal data}

\item{dtsurv}{survival data}

\item{...}{other parameter options, see \code{dynSurv}}
}
\value{
list of predicted values for the given id
}
\description{
prediction of survival probability and longitudinal marker using \code{joineRML} for BIG data
}
\examples{
   \donttest{
##
library(survival)
library(dplyr)
jmcs1<-joinRMLBig(dtlong=long2,
dtsurv = surv2,
longm=y~ x7+visit,
survm=Surv(time,status)~x1+visit,
rd=~ visit|id,
timeVar='visit',
samplesize=200,
id='id')
mod4<-jmcs1
P2<-predJRML(model<-mod4,ids<-c(10),dtlong=long2,dtsurv=surv2)
plot(P2$plong[[1]])
plot(P2$psurv[[1]])
##
   }
}
