% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{set_style}
\alias{set_style}
\title{Set a new style by list}
\usage{
set_style(style_name, style_entry)
}
\arguments{
\item{style_name}{[chr] name of the style to set}

\item{style_entry}{[list] named list representing the style entry}
}
\value{
[chr] invisible vector of input objects, to allow easier un-locking
}
\description{
Set a new style by list
}
\examples{
set_style(
   style_name    = "my_style"
   , style_entry = list(
      style_name             = "my_style"
      , prop_digits_round     = 1
      , prop_nsmall           = 1
      , count_method          = "sigfig"
      , count_digits_sigfig   = 3
      , count_pad_sigfigs     = TRUE
      , count_nsmall          = 1
      , count_big.mark        = ","
      , count_label_thousands = FALSE
      , rate_method           = "sigfig"
      , rate_digits_sigfig    = 3
      , rate_pad_sigfigs      = TRUE
      , rate_nsmall           = 1
      , decimal.mark          = "."
      , neg_mark_mean         = "-"
      , neg_mark_UI           = "-"
      , UI_only               = FALSE
      , UI_text               = ""
      , assert_clu_order      = TRUE
      , is_lancet             = FALSE
      , round_5_up            = TRUE
   )
)
}
\seealso{
Other styles: 
\code{\link{assert_style_schema}()},
\code{\link{get_style}()},
\code{\link{get_style_schema}()},
\code{\link{new_style}()},
\code{\link{style_lancet}()},
\code{\link{style_nature}()}
}
\concept{styles}
