% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queryBuilder.R
\name{queryBuilderInput}
\alias{queryBuilderInput}
\title{queryBuilderInput}
\usage{
queryBuilderInput(
  inputId,
  width = "100\%",
  filters,
  plugins = NULL,
  rules = NULL,
  optgroups = NULL,
  default_filter = NULL,
  sort_filters = FALSE,
  allow_groups = TRUE,
  allow_empty = FALSE,
  display_errors = FALSE,
  conditions = c("AND", "OR"),
  default_condition = "AND",
  inputs_separator = ",",
  display_empty_filter = TRUE,
  select_placeholder = "------",
  operators = NULL,
  add_na_filter = FALSE,
  return_value = c("r_rules", "rules", "sql", "all")
)
}
\arguments{
\item{inputId}{string. Input id for the builder.}

\item{width}{Width of the builder. Default if "100\%".}

\item{filters}{list of list specifying the available filters in the builder.
See example for a See https://querybuilder.js.org/#filters for details on the possible options}

\item{plugins}{list of optional plugins.}

\item{rules}{Initial set of rules.
By default the builder will contain one empty rule}

\item{optgroups}{List of groups in the filters and operators dropdowns.}

\item{default_filter}{string. The \code{id} of the default filter for any new rule.}

\item{sort_filters}{boolean \| string. Sort filters alphabetically,
or with a custom JS function.}

\item{allow_groups}{boolean \| integer. Number of allowed nested groups.
\code{TRUE} for no limit.}

\item{allow_empty}{boolean. If \code{TRUE}, no error will be thrown if the builder
is entirely empty.}

\item{display_errors}{boolean. If \code{TRUE}, when an error occurs on a rule,
display an icon with a tooltip explaining the error.}

\item{conditions}{string. Array of available group conditions. Use the
\code{lang} option to change the label.}

\item{default_condition}{Default active condition. Default 'AND'.}

\item{inputs_separator}{string used to separate multiple inputs (for between operator).
default is ",".}

\item{display_empty_filter}{boolean. Default \code{TRUE}. Add an empty option with \code{select_placeholder} string
to the filter dropdowns. If the empty filter is disabled and no \code{default_filter}
is defined, the first filter will be loaded when adding a rule.}

\item{select_placeholder}{string. Label of the "no filter" option.}

\item{operators}{NULL or list. If a list, format should follow that described
here: https://querybuilder.js.org/#operators}

\item{add_na_filter}{bool. Default is FALSE .If \code{TRUE}, \code{"is_na"} and \code{"is_not_na"}
are added to the global filter list for testing for NA values. Only works when
\code{return_type} is "rules" or "r_rules".}

\item{return_value}{string. On of \code{"r_rules"}, \code{"rules"}, \code{"sql_rules"}
or \code{"all"}. Default "r_rules". Determines the return value from the builder
accessed with input$<builder_id> in shiny server}
}
\value{
A \code{\link[htmltools:tagList]{htmltools::tagList()}} containing the queryBuilder
dependencies and configuration that can be added to a \code{shiny} UI definition.
}
\description{
Shiny input bindings for queryBuilder.
}
\examples{
library(shiny)
library(jqbr)

ui <- fluidPage(
  useQueryBuilder(),
  queryBuilderInput(
    inputId = "qb",
    filters = list(
      list(
        id = "name",
        type = "string"
      )
    )
  )
)

server <- function(input, output) {
  observeEvent(input$qb, {
    print(input$qb)
  })
}

# Add is_na filter

ui <- fluidPage(
  useQueryBuilder(),
  queryBuilderInput(
    inputId = "qb",
    add_na_filter = TRUE,
    return_value = "r_rules",
    filters = list(
      list(
        id = "name",
        type = "string"
      )
    )
  )
)

server <- function(input, output) {
  observeEvent(input$qb, {
    print(input$qb)
  })
}

if (interactive()) {
  shinyApp(ui, server)
}

}
