% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{SimSickleJrSmall}
\alias{SimSickleJrSmall}
\title{A small SickleJr object containing a subset of data from the
\verb{SimData} data object. Contains the completed analysis from the
`Getting Started` vignette for a small subset of 10 cells with 150 genes and
700 peaks. The clusters derived from this dataset are not accurate; this dataset
is intended for use with code examples.}
\format{
A SickleJr object containing a completed analysis using jrSiCKLSNMF
\describe{
\item{count.matrices}{Contains a list of 2 sparse matrices, each containing a different
simulated omics modality measured on the same set of single cells}
\item{normalized.count.matrices}{The normalized versions of the count matrices
contained in slot \code{count.matrices}}
\item{graph.laplacian.list}{A list of sparse matrices containing the graph
Laplacians corresponding to the KNN feature-feature similarity graphs constructed
for each omics modality}
\item{rowRegularization}{A string indicating the row regularization: here it
is set to \code{"None"}}
\item{diffFunc}{A string specifying the function to measure the discrepancy
between the normalized data and the fitted matrices: here, it is set to "klp"
for the Poisson Kullback-Leibler divergence}
\item{lambdaWlist}{A list holding the graph regularization parameters: here,
they are 10 and 50}
\item{lambdaH}{A numeric indicating the value for the sparsity parameter.
Here it is equals 500}
\item{Wlist}{A list holding the fitted \eqn{\mathbf{W}^v} matrices}
\item{H}{A matrix holding \eqn{\mathbf{H}}}
\item{WHinitials}{A list of initial values for \eqn{\mathbf{W}^v} and \eqn{\mathbf{H}}}
\item{lossCalcSubsample}{A vector containing a subset on which to calculate the loss}
\item{latent.factor.elbow.values}{A data frame holding the loss and the number of latent factor that is used for diagnostic plots}
\item{minibatch}{A Boolean indicating whether or not to use the mini-batch algorithm: \code{FALSE} here}
\item{clusterdiagnostics}{Diagnostic plots and results}
\item{clusters}{A list holding the \code{"kmeans"} clustering results}
\item{metadata}{A list holding metadata; here this is just cell type information}
\item{loss}{A list holding a vector called "Loss"}
\item{umap}{A list holding various UMAP approximations}
\item{plots}{A list holding ggplots corresponding to different diagnostics and visualizations}
}
}
\source{
\href{https://github.com/ellisdoro/jrSiCKLSNMF_Simulations}{jrSicKLSNMF Simulations}
}
\usage{
data(SimSickleJrSmall)
}
\description{
A small SickleJr object containing a subset of data from the
\verb{SimData} data object. Contains the completed analysis from the
`Getting Started` vignette for a small subset of 10 cells with 150 genes and
700 peaks. The clusters derived from this dataset are not accurate; this dataset
is intended for use with code examples.
}
\keyword{datasets}
