% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/typescript.R
\name{typescript}
\alias{typescript}
\title{Transpile TypeScript code to JavaScript}
\usage{
typescript(input, options = NULL)
}
\arguments{
\item{input}{Either a path to a file or a character string containing the TypeScript code to be transpiled.}

\item{options}{A list of options to pass to the TypeScript transpiler. See the
\href{https://www.typescriptlang.org/docs/handbook/compiler-options.html}{TypeScript documentation} for available options.}
}
\value{
A list containing the transpiled JavaScript code and any diagnostics.
}
\description{
This function uses the TypeScript compiler to transpile TypeScript code into JavaScript. Note that the
first time this function is called, it will load the TypeScript library into the JavaScript context,
which may take a few seconds. Subsequent calls will be faster.
}
\examples{
ts_code <- "const greet = (name: string): string => `Hello, ${name}!`;"
typescript(ts_code, list(compilerOptions = list(target = "ES5")))

}
