% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jubilee-repo-constructor.R
\name{jubilee.repo}
\alias{jubilee.repo}
\title{Constructor of \code{jubilee.repo} class}
\usage{
jubilee.repo(online = TRUE, force = TRUE)
}
\arguments{
\item{online}{logical, indicating whether to fetch data from online resource or not. Default is \code{TRUE}.}

\item{force}{logical, if FALSE, allowed to retrieve previous object stored in option.
The FALSE setting overrides the online=TRUE setting. Default is \code{TRUE}.}
}
\value{
An object of \code{jubilee.repo} class
}
\description{
Construct a \code{jubilee.repo} class by combining data from that of Robert Shiller
since 1871, historical stock market data from 1802 to 1987 by William Schwert,
3-month Treasury bill rate, gold price, and several other economic time series from FRED.
Optionally, this function can fetch more recent data from the website of Robert Shiller and
Federal Reserve FRED website if the R session has connection to the internet.
}
\examples{
\dontrun{
  repo <- jubilee.repo(online=FALSE)
  dtb <- repo@ie
  tail(dtb,1)
}

}
\author{
Stephen H. Lihn
}
\keyword{constructor}
