% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_getJuicr_Extractions.R
\name{file_getJuicr_Extractions}
\alias{file_getJuicr_Extractions}
\title{Reads a *_juicr.html report and retrieves data extractions and history.}
\usage{
file_getJuicr_Extractions(aFileName = file.choose(), quiet = FALSE)
}
\arguments{
\item{aFileName}{The file name and location of a *_juicr.html report.  Prompts
for file name if none is explicitly called.  Must be .html format.}

\item{quiet}{When \code{"TRUE"}, does not display all extraction tables.}
}
\value{
A list of tables including all extractions, coordinates, image file
    names, and \code{juicr} GUI parameters.
}
\description{
Reads a juicr generated report of image extractions contained within the .html file.
}
\examples{
\dontrun{

theExtraction <- file_getJuicr_Extractions("pretend_image_juicr.html")
print(theExtraction$points)

}

}
\seealso{
\link{file_getJuicr_Images}
}
