% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{trigseas}
\alias{trigseas}
\title{Trigonometric seasonal variables}
\usage{
trigseas(n, s, harmonics = NULL)
}
\arguments{
\item{n}{length of time series;}

\item{s}{seasonal period;}

\item{harmonics}{vector of harmonics to be used: the cosine and sine
functions are computed at frequencies \code{2*pi*harmonics/s}, if there
is an element of \code{harmonics} for which \code{2*pi*harmonics/s} is equal
to \eqn{\pi} the corresponding sine is omitted.}
}
\value{
It returns a matrix with n rows and so many columns
as the harmonics (by default these are \eqn{s-1}).
}
\description{
It produces a matrix with seasonal sinusoids to be used as
regressors. By default, for \eqn{t=1,\ldots,n} and
\eqn{j = 1, \ldots, \lfloor s/2\rfloor}, it computes
\deqn{\cos(2\pi j/s), \qquad \sin(2\pi j/s)}.
Notice that if $s$ is even the sine function at highest
frequency is omitted because it equals zero for all $t$.
The used can select a different set of harmonics.
}
\examples{
y <- log(AirPassengers)
X <- trigseas(length(y), 12)
X <- cbind(X, t = 1:length(y))
reg <- lm(y~X)
}
