% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runVar.R
\name{runVar}
\alias{runVar}
\title{Running Variances}
\usage{
runVar(data, wsize = 25)
}
\arguments{
\item{data}{\emph{N} x \emph{v} dataframe where \emph{N} is the no. of time points and \emph{v} the no. of variables}

\item{wsize}{Window size}
}
\value{
Running variances time series
}
\description{
Extracts the running variances by sliding a window comprised of \code{wsize} time points, and in each window, the variance for each variable is computed.
Each time the window is slid, the oldest time point is discarded and the latest time point is added.
}
\examples{
phase1=cbind(rnorm(50,0,1),rnorm(50,0,1)) #phase1: SD=1
phase2=cbind(rnorm(50,0,2),rnorm(50,0,2)) #phase2: SD=2
X=rbind(phase1,phase2)
RS=runVar(data=X,wsize=25)
ts.plot(RS, gpars=list(xlab="Window", ylab="Variances", col=1:2,lwd=2))

}
