% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_ctc_batch_cost}
\alias{k_ctc_batch_cost}
\title{Runs CTC loss algorithm on each batch element.}
\usage{
k_ctc_batch_cost(y_true, y_pred, input_length, label_length)
}
\arguments{
\item{y_true}{tensor \verb{(samples, max_string_length)} containing the truth
labels.}

\item{y_pred}{tensor \verb{(samples, time_steps, num_categories)} containing the
prediction, or output of the softmax.}

\item{input_length}{tensor \verb{(samples, 1)} containing the sequence length for
each batch item in \code{y_pred}.}

\item{label_length}{tensor \verb{(samples, 1)} containing the sequence length for
each batch item in \code{y_true}.}
}
\value{
Tensor with shape (samples,1) containing the CTC loss of each
element.
}
\description{
Runs CTC loss algorithm on each batch element.
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://tensorflow.rstudio.com/reference/keras/index.html#backend}.
}

